/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.spring.autoconfigure.SamplerProperties;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SamplerProperties.class})
public class OpenTelemetryAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    public static class OpenTelemetryBeanConfig {
        @Bean
        @ConditionalOnMissingBean
        public SdkTracerProvider sdkTracerProvider(SamplerProperties samplerProperties, ObjectProvider<List<SpanExporter>> spanExportersProvider) {
            SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
            ((List)spanExportersProvider.getIfAvailable(Collections::emptyList)).stream().map(spanExporter -> BatchSpanProcessor.builder((SpanExporter)spanExporter).build()).forEach(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).addSpanProcessor(arg_0));
            return tracerProviderBuilder.setSampler(Sampler.traceIdRatioBased((double)samplerProperties.getProbability())).build();
        }

        @Bean
        public OpenTelemetry openTelemetry(ObjectProvider<ContextPropagators> propagatorsProvider, SdkTracerProvider tracerProvider) {
            ContextPropagators propagators = (ContextPropagators)propagatorsProvider.getIfAvailable(ContextPropagators::noop);
            return OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).build();
        }
    }
}

