/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNames;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.JoinPointRequest;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.WithSpanAspectParameterAttributeNamesExtractor;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.ParameterNameDiscoverer;

@Aspect
public class WithSpanAspect {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-boot-autoconfigure";
    private final Instrumenter<JoinPointRequest, Object> instrumenter;

    public WithSpanAspect(OpenTelemetry openTelemetry, ParameterNameDiscoverer parameterNameDiscoverer) {
        WithSpanAspectParameterAttributeNamesExtractor parameterAttributeNamesExtractor = new WithSpanAspectParameterAttributeNamesExtractor(parameterNameDiscoverer);
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, WithSpanAspect::spanName).addAttributesExtractor((AttributesExtractor)MethodSpanAttributesExtractor.newInstance(JoinPointRequest::method, (ParameterAttributeNamesExtractor)parameterAttributeNamesExtractor, JoinPointRequest::args)).newInstrumenter(WithSpanAspect::spanKind);
    }

    private static String spanName(JoinPointRequest request) {
        WithSpan annotation = request.annotation();
        String spanName = annotation.value();
        if (spanName.isEmpty()) {
            return SpanNames.fromMethod((Method)request.method());
        }
        return spanName;
    }

    private static SpanKind spanKind(JoinPointRequest request) {
        return request.annotation().kind();
    }

    @Around(value="@annotation(io.opentelemetry.extension.annotations.WithSpan)")
    public Object traceMethod(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        block9: {
            JoinPointRequest request = new JoinPointRequest((JoinPoint)pjp);
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
                return pjp.proceed();
            }
            Context context = this.instrumenter.start(parentContext, (Object)request);
            AsyncOperationEndSupport asyncOperationEndSupport = AsyncOperationEndSupport.create(this.instrumenter, Object.class, request.method().getReturnType());
            Scope ignored = context.makeCurrent();
            try {
                Object response = pjp.proceed();
                object = asyncOperationEndSupport.asyncEnd(context, (Object)request, response, null);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    asyncOperationEndSupport.asyncEnd(context, (Object)request, null, t);
                    throw t;
                }
            }
            ignored.close();
        }
        return object;
    }
}

