/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.resources;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionParser;

public class SpringResourceConfigProperties
implements ConfigProperties {
    private final Environment environment;
    private final ExpressionParser parser;

    public SpringResourceConfigProperties(Environment environment, ExpressionParser parser) {
        this.environment = environment;
        this.parser = parser;
    }

    @Nullable
    public String getString(String name) {
        return (String)this.environment.getProperty(name, String.class);
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return (Boolean)this.environment.getProperty(name, Boolean.class);
    }

    @Nullable
    public Integer getInt(String name) {
        return (Integer)this.environment.getProperty(name, Integer.class);
    }

    @Nullable
    public Long getLong(String name) {
        return (Long)this.environment.getProperty(name, Long.class);
    }

    @Nullable
    public Double getDouble(String name) {
        return (Double)this.environment.getProperty(name, Double.class);
    }

    @Nullable
    public Duration getDuration(String name) {
        return (Duration)this.environment.getProperty(name, Duration.class);
    }

    public List<String> getList(String name) {
        return (List)this.environment.getProperty(name, List.class);
    }

    public Map<String, String> getMap(String name) {
        String value = this.environment.getProperty(name);
        return (Map)this.parser.parseExpression(Objects.requireNonNull(value)).getValue();
    }
}

