/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.httpclients.webclient;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.client.WebClientTracingFilter;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientBeanPostProcessor
implements BeanPostProcessor {
    private final OpenTelemetry openTelemetry;

    WebClientBeanPostProcessor(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return this.wrapBuilder(this.openTelemetry, webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return this.wrapBuilder(this.openTelemetry, webClientBuilder);
        }
        return bean;
    }

    private WebClient.Builder wrapBuilder(OpenTelemetry openTelemetry, WebClient.Builder webClientBuilder) {
        return webClientBuilder.filters(this.webClientFilterFunctionConsumer(openTelemetry));
    }

    private Consumer<List<ExchangeFilterFunction>> webClientFilterFunctionConsumer(OpenTelemetry openTelemetry) {
        return functions -> {
            if (functions.stream().noneMatch(filter -> filter instanceof WebClientTracingFilter)) {
                WebClientTracingFilter.addFilter((OpenTelemetry)openTelemetry, (List)functions);
            }
        };
    }
}

