/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class OtlpHttpMetricExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final Function<InstrumentType, AggregationTemporality> DEFAULT_AGGREGATION_TEMPORALITY_FUNCTION = MetricExporter::alwaysCumulative;
    private final OkHttpExporterBuilder<MetricsRequestMarshaler> delegate;
    private Function<InstrumentType, AggregationTemporality> aggregationTemporalityFunction = DEFAULT_AGGREGATION_TEMPORALITY_FUNCTION;

    OtlpHttpMetricExporterBuilder() {
        this.delegate = new OkHttpExporterBuilder("metric", DEFAULT_ENDPOINT);
    }

    public OtlpHttpMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpHttpMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustedCertificates(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setClientTls(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setAggregationTemporality(Function<InstrumentType, AggregationTemporality> aggregationTemporalityFunction) {
        Objects.requireNonNull(aggregationTemporalityFunction, "aggregationTemporalityFunction");
        this.aggregationTemporalityFunction = aggregationTemporalityFunction;
        return this;
    }

    public OtlpHttpMetricExporter build() {
        return new OtlpHttpMetricExporter((OkHttpExporter<MetricsRequestMarshaler>)this.delegate.build(), this.aggregationTemporalityFunction);
    }
}

