/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import javax.annotation.Nullable;

final class SpanExporterConfiguration {
    @Nullable
    static SpanExporter configureExporter(String name, ConfigProperties config) {
        switch (name) {
            case "otlp": 
            case "otlp_span": {
                return SpanExporterConfiguration.configureOtlpSpans(config);
            }
            case "jaeger": {
                return SpanExporterConfiguration.configureJaeger(config);
            }
            case "zipkin": {
                return SpanExporterConfiguration.configureZipkin(config);
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingSpanExporter", "Logging Trace Exporter", "opentelemetry-exporter-logging");
                return new LoggingSpanExporter();
            }
        }
        return null;
    }

    static OtlpGrpcSpanExporter configureOtlpSpans(ConfigProperties config) {
        boolean insecure;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter", "OTLP Trace Exporter", "opentelemetry-exporter-otlp-trace");
        OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.otlp.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if (!(insecure = config.getBoolean("otel.exporter.otlp.insecure"))) {
            builder.setUseTls(true);
        }
        config.getCommaSeparatedMap("otel.exporter.otlp.headers").forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
        Long timeoutMillis = config.getLong("otel.exporter.otlp.timeout");
        if (timeoutMillis != null) {
            builder.setTimeout(Duration.ofMillis(timeoutMillis));
        }
        return builder.build();
    }

    private static SpanExporter configureJaeger(ConfigProperties config) {
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter", "Jaeger gRPC Exporter", "opentelemetry-exporter-jaeger");
        JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.jaeger.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        return builder.build();
    }

    private static SpanExporter configureZipkin(ConfigProperties config) {
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.zipkin.ZipkinSpanExporter", "Zipkin Exporter", "opentelemetry-exporter-zipkin");
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        return builder.build();
    }

    private SpanExporterConfiguration() {
    }
}

