/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.SpanExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

final class TracerProviderConfiguration {
    static SdkTracerProvider configureTracerProvider(Resource resource, ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer, BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer) {
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder().setResource(resource).setSpanLimits(TracerProviderConfiguration.configureSpanLimits(config));
        String sampler = config.getString("otel.traces.sampler");
        if (sampler == null) {
            sampler = "parentbased_always_on";
        }
        tracerProviderBuilder.setSampler(samplerCustomizer.apply((Sampler)TracerProviderConfiguration.configureSampler(sampler, config, serviceClassLoader), config));
        for (SdkTracerProviderConfigurer configurer : ServiceLoader.load(SdkTracerProviderConfigurer.class, serviceClassLoader)) {
            configurer.configure(tracerProviderBuilder, config);
        }
        Map<String, SpanExporter> exportersByName = SpanExporterConfiguration.configureSpanExporters(config, serviceClassLoader, meterProvider, spanExporterCustomizer);
        TracerProviderConfiguration.configureSpanProcessors(config, exportersByName).forEach(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).addSpanProcessor(arg_0));
        SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)tracerProvider).close()));
        return tracerProvider;
    }

    static List<SpanProcessor> configureSpanProcessors(ConfigProperties config, Map<String, SpanExporter> exportersByName) {
        HashMap<String, SpanExporter> exportersByNameCopy = new HashMap<String, SpanExporter>(exportersByName);
        ArrayList<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
        SpanExporter exporter = exportersByName.get("logging");
        if (exporter != null) {
            spanProcessors.add(SimpleSpanProcessor.create((SpanExporter)exporter));
            exportersByNameCopy.remove("logging");
        }
        if (!exportersByNameCopy.isEmpty()) {
            SpanExporter compositeSpanExporter = SpanExporter.composite(exportersByNameCopy.values());
            spanProcessors.add((SpanProcessor)TracerProviderConfiguration.configureBatchSpanProcessor(config, compositeSpanExporter));
        }
        return spanProcessors;
    }

    static BatchSpanProcessor configureBatchSpanProcessor(ConfigProperties config, SpanExporter exporter) {
        Duration timeout;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder((SpanExporter)exporter);
        Duration scheduleDelay = config.getDuration("otel.bsp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt("otel.bsp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue.intValue());
        }
        if ((maxExportBatch = config.getInt("otel.bsp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch.intValue());
        }
        if ((timeout = config.getDuration("otel.bsp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout);
        }
        return builder.build();
    }

    static SpanLimits configureSpanLimits(ConfigProperties config) {
        Integer maxLinks;
        Integer maxEvents;
        Integer maxAttrs;
        SpanLimitsBuilder builder = SpanLimits.builder();
        Integer maxLength = config.getInt("otel.span.attribute.value.length.limit");
        if (maxLength != null) {
            builder.setMaxAttributeValueLength(maxLength.intValue());
        }
        if ((maxAttrs = config.getInt("otel.span.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs.intValue());
        }
        if ((maxEvents = config.getInt("otel.span.event.count.limit")) != null) {
            builder.setMaxNumberOfEvents(maxEvents.intValue());
        }
        if ((maxLinks = config.getInt("otel.span.link.count.limit")) != null) {
            builder.setMaxNumberOfLinks(maxLinks.intValue());
        }
        return builder.build();
    }

    static Sampler configureSampler(String sampler, ConfigProperties config, ClassLoader serviceClassLoader) {
        Map<String, Sampler> spiSamplers = SpiUtil.loadConfigurable(ConfigurableSamplerProvider.class, Collections.singletonList(sampler), ConfigurableSamplerProvider::getName, ConfigurableSamplerProvider::createSampler, config, serviceClassLoader);
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                Double ratio = config.getDouble("otel.traces.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.traceIdRatioBased((double)ratio);
            }
            case "parentbased_always_on": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                Double ratio = config.getDouble("otel.traces.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)ratio));
            }
        }
        Sampler spiSampler = spiSamplers.get(sampler);
        if (spiSampler == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.sampler: " + sampler);
        }
        return spiSampler;
    }

    private TracerProviderConfiguration() {
    }
}

