/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DoubleLastValueAggregator
extends AbstractAggregator<Double> {
    DoubleLastValueAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor) {
        super(resource, instrumentationLibraryInfo, descriptor, true);
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    public Double merge(Double a1, Double a2) {
        return a2;
    }

    @Override
    public MetricData toMetricData(Map<Attributes, Double> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleGauge(this.getResource(), this.getInstrumentationLibraryInfo(), this.getMetricDescriptor().getName(), this.getMetricDescriptor().getDescription(), this.getMetricDescriptor().getUnit(), DoubleGaugeData.create(MetricDataUtils.toDoublePointList(accumulationByLabels, 0L, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.getAndSet(DEFAULT_VALUE);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

