/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.AutoValue_MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.DuplicateMetricStorageException;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.MultiWritableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MeterSharedState {
    private static final Logger logger = Logger.getLogger(MeterSharedState.class.getName());

    public static MeterSharedState create(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        return new AutoValue_MeterSharedState(instrumentationLibraryInfo, new MetricStorageRegistry());
    }

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    abstract MetricStorageRegistry getMetricStorageRegistry();

    public List<MetricData> collectAll(MeterProviderSharedState meterProviderSharedState, long epochNanos) {
        Collection<MetricStorage> metrics = this.getMetricStorageRegistry().getMetrics();
        ArrayList<MetricData> result = new ArrayList<MetricData>(metrics.size());
        for (MetricStorage metric : metrics) {
            MetricData current = metric.collectAndReset(meterProviderSharedState.getStartEpochNanos(), epochNanos);
            if (current == null) continue;
            result.add(current);
        }
        return result;
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState) {
        List<View> views = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo());
        ArrayList<WriteableMetricStorage> storage = new ArrayList<WriteableMetricStorage>(views.size());
        for (View view : views) {
            if (view.getAggregation().config(instrument) == null) continue;
            try {
                storage.add(this.getMetricStorageRegistry().register(SynchronousMetricStorage.create(view, instrument, meterProviderSharedState.getResource(), this.getInstrumentationLibraryInfo(), meterProviderSharedState.getStartEpochNanos())));
            }
            catch (DuplicateMetricStorageException e) {
                logger.log(Level.WARNING, e, () -> "Failed to register metric.");
            }
        }
        if (storage.size() == 1) {
            return (WriteableMetricStorage)storage.get(0);
        }
        return new MultiWritableMetricStorage(storage);
    }

    public final void registerLongAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableLongMeasurement> metricUpdater) {
        List<View> views = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo());
        for (View view : views) {
            if (view.getAggregation().config(instrument) == null) continue;
            try {
                this.getMetricStorageRegistry().register(AsynchronousMetricStorage.longAsynchronousAccumulator(view, instrument, meterProviderSharedState.getResource(), this.getInstrumentationLibraryInfo(), meterProviderSharedState.getStartEpochNanos(), metricUpdater));
            }
            catch (DuplicateMetricStorageException e) {
                logger.log(Level.WARNING, e, () -> "Failed to register metric.");
            }
        }
    }

    public final void registerDoubleAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        List<View> views = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo());
        for (View view : views) {
            if (view.getAggregation().config(instrument) == null) continue;
            try {
                this.getMetricStorageRegistry().register(AsynchronousMetricStorage.doubleAsynchronousAccumulator(view, instrument, meterProviderSharedState.getResource(), this.getInstrumentationLibraryInfo(), meterProviderSharedState.getStartEpochNanos(), metricUpdater));
            }
            catch (DuplicateMetricStorageException e) {
                logger.log(Level.WARNING, e, () -> "Failed to register metric.");
            }
        }
    }
}

