/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.config;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.config.AutoValue_TraceConfig;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class TraceConfig {
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 32;
    public static final int UNLIMITED_ATTRIBUTE_LENGTH = -1;
    private static final int DEFAULT_MAX_ATTRIBUTE_LENGTH = -1;
    private static final TraceConfig DEFAULT = TraceConfig.builder().build();

    public static TraceConfig getDefault() {
        return DEFAULT;
    }

    public abstract Sampler getSampler();

    public abstract int getMaxNumberOfAttributes();

    public abstract int getMaxNumberOfEvents();

    public abstract int getMaxNumberOfLinks();

    public abstract int getMaxNumberOfAttributesPerEvent();

    public abstract int getMaxNumberOfAttributesPerLink();

    public abstract int getMaxLengthOfAttributeValues();

    public boolean shouldTruncateStringAttributeValues() {
        return this.getMaxLengthOfAttributeValues() != -1;
    }

    private static Builder builder() {
        return new AutoValue_TraceConfig.Builder().setSampler(DEFAULT_SAMPLER).setMaxNumberOfAttributes(1000).setMaxNumberOfEvents(1000).setMaxNumberOfLinks(1000).setMaxNumberOfAttributesPerEvent(32).setMaxNumberOfAttributesPerLink(32).setMaxLengthOfAttributeValues(-1);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_SAMPLER_PROBABILITY = "otel.config.sampler.probability";
        private static final String KEY_SPAN_ATTRIBUTE_COUNT_LIMIT = "otel.span.attribute.count.limit";
        private static final String KEY_SPAN_EVENT_COUNT_LIMIT = "otel.span.event.count.limit";
        private static final String KEY_SPAN_LINK_COUNT_LIMIT = "otel.span.link.count.limit";
        private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = "otel.config.max.event.attrs";
        private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = "otel.config.max.link.attrs";
        private static final String KEY_SPAN_ATTRIBUTE_MAX_VALUE_LENGTH = "otel.config.max.attr.length";

        Builder() {
        }

        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            Integer intValue;
            Double doubleValue = Builder.getDoubleProperty((String)KEY_SAMPLER_PROBABILITY, (Map)(configMap = namingConvention.normalize(configMap)));
            if (doubleValue != null) {
                this.setTraceIdRatioBased(doubleValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_ATTRIBUTE_COUNT_LIMIT, (Map)configMap)) != null) {
                this.setMaxNumberOfAttributes(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_EVENT_COUNT_LIMIT, (Map)configMap)) != null) {
                this.setMaxNumberOfEvents(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_LINK_COUNT_LIMIT, (Map)configMap)) != null) {
                this.setMaxNumberOfLinks(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT, (Map)configMap)) != null) {
                this.setMaxNumberOfAttributesPerEvent(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK, (Map)configMap)) != null) {
                this.setMaxNumberOfAttributesPerLink(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_ATTRIBUTE_MAX_VALUE_LENGTH, (Map)configMap)) != null) {
                this.setMaxLengthOfAttributeValues(intValue);
            }
            return this;
        }

        public Builder readProperties(Properties properties) {
            return (Builder)((Object)super.readProperties(properties));
        }

        public Builder readEnvironmentVariables() {
            return (Builder)((Object)super.readEnvironmentVariables());
        }

        public Builder readSystemProperties() {
            return (Builder)((Object)super.readSystemProperties());
        }

        public abstract Builder setSampler(Sampler var1);

        public Builder setTraceIdRatioBased(double samplerRatio) {
            Utils.checkArgument((samplerRatio >= 0.0 ? 1 : 0) != 0, (String)"samplerRatio must be greater than or equal to 0.");
            Utils.checkArgument((samplerRatio <= 1.0 ? 1 : 0) != 0, (String)"samplerRatio must be lesser than or equal to 1.");
            if (samplerRatio == 1.0) {
                this.setSampler(Sampler.parentBased(Sampler.alwaysOn()));
            } else if (samplerRatio == 0.0) {
                this.setSampler(Sampler.alwaysOff());
            } else {
                this.setSampler(Sampler.parentBased(Sampler.traceIdRatioBased(samplerRatio)));
            }
            return this;
        }

        public abstract Builder setMaxNumberOfAttributes(int var1);

        public abstract Builder setMaxNumberOfEvents(int var1);

        public abstract Builder setMaxNumberOfLinks(int var1);

        public abstract Builder setMaxNumberOfAttributesPerEvent(int var1);

        public abstract Builder setMaxNumberOfAttributesPerLink(int var1);

        public abstract Builder setMaxLengthOfAttributeValues(int var1);

        abstract TraceConfig autoBuild();

        public TraceConfig build() {
            TraceConfig traceConfig = this.autoBuild();
            if (traceConfig.getMaxNumberOfAttributes() <= 0) {
                throw new IllegalArgumentException("maxNumberOfAttributes must be greater than 0");
            }
            if (traceConfig.getMaxNumberOfEvents() <= 0) {
                throw new IllegalArgumentException("maxNumberOfEvents must be greater than 0");
            }
            if (traceConfig.getMaxNumberOfLinks() <= 0) {
                throw new IllegalArgumentException("maxNumberOfLinks must be greater than 0");
            }
            if (traceConfig.getMaxNumberOfAttributesPerEvent() <= 0) {
                throw new IllegalArgumentException("maxNumberOfAttributesPerEvent must be greater than 0");
            }
            if (traceConfig.getMaxNumberOfAttributesPerLink() <= 0) {
                throw new IllegalArgumentException("maxNumberOfAttributesPerLink must be greater than 0");
            }
            if (traceConfig.getMaxLengthOfAttributeValues() < -1) {
                throw new IllegalArgumentException("maxLengthOfAttributeValues must be -1 to disable length restriction, or 0 or higher to enable length restriction");
            }
            return traceConfig;
        }
    }
}

