/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.ContainerInfo;
import java.beans.ConstructorProperties;
import java.util.Map;

public final class Container
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Container.class);
    private final ContainerInfo containerInfo;
    private final Map<Integer, Integer> targetPortToHostPortLookup;
    private final String dockerHost;
    private final DockerClient client;

    @Override
    public void close() {
        try {
            this.client.stopContainer(this.containerInfo.id(), 10);
        }
        catch (DockerException | InterruptedException e) {
            logger.error(e, "Error stopping container", new Object[0]);
        }
        this.client.close();
    }

    @ConstructorProperties(value={"containerInfo", "targetPortToHostPortLookup", "dockerHost", "client"})
    public Container(ContainerInfo containerInfo, Map<Integer, Integer> targetPortToHostPortLookup, String dockerHost, DockerClient client) {
        this.containerInfo = containerInfo;
        this.targetPortToHostPortLookup = targetPortToHostPortLookup;
        this.dockerHost = dockerHost;
        this.client = client;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public Map<Integer, Integer> getTargetPortToHostPortLookup() {
        return this.targetPortToHostPortLookup;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public DockerClient getClient() {
        return this.client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        ContainerInfo this$containerInfo = this.getContainerInfo();
        ContainerInfo other$containerInfo = other.getContainerInfo();
        if (this$containerInfo == null ? other$containerInfo != null : !this$containerInfo.equals(other$containerInfo)) {
            return false;
        }
        Map<Integer, Integer> this$targetPortToHostPortLookup = this.getTargetPortToHostPortLookup();
        Map<Integer, Integer> other$targetPortToHostPortLookup = other.getTargetPortToHostPortLookup();
        if (this$targetPortToHostPortLookup == null ? other$targetPortToHostPortLookup != null : !((Object)this$targetPortToHostPortLookup).equals(other$targetPortToHostPortLookup)) {
            return false;
        }
        String this$dockerHost = this.getDockerHost();
        String other$dockerHost = other.getDockerHost();
        if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
            return false;
        }
        DockerClient this$client = this.getClient();
        DockerClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContainerInfo $containerInfo = this.getContainerInfo();
        result = result * 59 + ($containerInfo == null ? 43 : $containerInfo.hashCode());
        Map<Integer, Integer> $targetPortToHostPortLookup = this.getTargetPortToHostPortLookup();
        result = result * 59 + ($targetPortToHostPortLookup == null ? 43 : ((Object)$targetPortToHostPortLookup).hashCode());
        String $dockerHost = this.getDockerHost();
        result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
        DockerClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "Container(containerInfo=" + this.getContainerInfo() + ", targetPortToHostPortLookup=" + this.getTargetPortToHostPortLookup() + ", dockerHost=" + this.getDockerHost() + ", client=" + this.getClient() + ")";
    }
}

