/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerInfo;
import io.paradoxical.Container;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExistingContainer
implements AutoCloseable {
    private final ContainerInfo containerInfo;
    private final DockerClient client;
    private static final Logger logger = LoggerFactory.getLogger(Container.class);

    @Override
    public void close() {
        try {
            this.client.stopContainer(this.containerInfo.id(), 10);
            this.client.removeContainer(this.containerInfo.id());
        }
        catch (DockerException | InterruptedException e) {
            logger.error("Error stopping container", e);
        }
    }

    @ConstructorProperties(value={"containerInfo", "client"})
    public ExistingContainer(ContainerInfo containerInfo, DockerClient client) {
        this.containerInfo = containerInfo;
        this.client = client;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public DockerClient getClient() {
        return this.client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExistingContainer)) {
            return false;
        }
        ExistingContainer other = (ExistingContainer)o;
        ContainerInfo this$containerInfo = this.getContainerInfo();
        ContainerInfo other$containerInfo = other.getContainerInfo();
        if (this$containerInfo == null ? other$containerInfo != null : !this$containerInfo.equals(other$containerInfo)) {
            return false;
        }
        DockerClient this$client = this.getClient();
        DockerClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContainerInfo $containerInfo = this.getContainerInfo();
        result = result * 59 + ($containerInfo == null ? 43 : $containerInfo.hashCode());
        DockerClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "ExistingContainer(containerInfo=" + this.getContainerInfo() + ", client=" + this.getClient() + ")";
    }
}

