/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.v2;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.spotify.docker.client.exceptions.DockerException;
import io.paradoxical.DockerClientConfig;
import io.paradoxical.EnvironmentVar;
import io.paradoxical.LogMatcher;
import io.paradoxical.MappedPort;
import io.paradoxical.v2.Container;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCreator {
    private static final Logger logger = LoggerFactory.getLogger(io.paradoxical.DockerCreator.class);
    private static Random random = new Random();

    public static Container build(DockerClientConfig config) throws DockerException, InterruptedException {
        return DockerCreator.build(config, null);
    }

    public static DockerClient defaultClient() {
        DefaultDockerClientConfig dockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        return DockerClientBuilder.getInstance((com.github.dockerjava.core.DockerClientConfig)dockerClientConfig).build();
    }

    public static Container build(DockerClientConfig config, AuthConfig authConfig) throws InterruptedException, DockerException {
        return DockerCreator.build(config, authConfig, DockerCreator.defaultClient(), DefaultDockerClientConfig.createDefaultConfigBuilder().build());
    }

    public static Container build(DockerClientConfig config, AuthConfig authConfig, DockerClient client, DefaultDockerClientConfig clientConfig) throws InterruptedException, DockerException {
        Ports ports = new Ports();
        for (MappedPort port : config.getMappedPorts()) {
            ports.bind(ExposedPort.tcp((int)port.getContainerPort()), Ports.Binding.bindPort((int)port.getHostPort()));
        }
        for (Integer transientPort : config.getTransientPorts()) {
            ports.bind(ExposedPort.tcp((int)transientPort), Ports.Binding.bindPort((int)(random.nextInt(30000) + 15000)));
        }
        CreateContainerCmd createContainerCmd = client.createContainerCmd(config.getImageName()).withPortBindings(ports).withLxcConf(new LxcConf[]{new LxcConf("icc", "false")}).withEnv(EnvironmentVar.asEnvVars(config.getEnvVars()));
        if (config.getArguments() != null) {
            createContainerCmd.withCmd(config.getArguments().split(" "));
        }
        if (config.getContainerName() != null) {
            createContainerCmd.withName(config.getContainerName());
        }
        if (config.isPullAlways()) {
            PullImageResultCallback pullImageResultCallback = new PullImageResultCallback();
            PullImageCmd pullImageCmd = client.pullImageCmd(config.getImageName());
            if (authConfig != null) {
                pullImageCmd.withAuthConfig(authConfig);
            } else {
                DockerCreator.setAuthFromFile(pullImageCmd, clientConfig, config.getImageName());
            }
            pullImageCmd.exec((ResultCallback)pullImageResultCallback);
            pullImageResultCallback.awaitSuccess();
        }
        config.getContainerConfigurator().configure(createContainerCmd);
        CreateContainerResponse containerResponse = createContainerCmd.exec();
        client.startContainerCmd(containerResponse.getId()).exec();
        logger.info("Starting container id " + containerResponse.getId() + ", " + config.getImageName());
        if (config.getWaitForLogLine() != null) {
            DockerCreator.waitForContainer(containerResponse, client, config);
        }
        logger.info("Container id " + containerResponse.getId() + " ready");
        return new Container(containerResponse, DockerCreator.getMappedPorts(ports), DockerCreator.getHost(clientConfig.getDockerHost()), client);
    }

    private static void setAuthFromFile(PullImageCmd pullImageCmd, DefaultDockerClientConfig dockerClientConfig, String imageName) {
        AuthConfig authConfig = dockerClientConfig.effectiveAuthConfig(imageName);
        if (authConfig != null) {
            pullImageCmd.withAuthConfig(authConfig);
        }
    }

    private static String getHost(URI dockerHost) {
        if (Objects.equals(dockerHost.getScheme(), "unix")) {
            return "localhost";
        }
        return dockerHost.getHost();
    }

    private static void waitForContainer(CreateContainerResponse containerResponse, DockerClient client, final DockerClientConfig config) throws InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        LogContainerCmd logContainerCmd = client.logContainerCmd(containerResponse.getId()).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true));
        logContainerCmd.exec((ResultCallback)new LogContainerResultCallback(){

            public void onNext(Frame item) {
                if (LogMatcher.matches(item.toString(), config.getWaitForLogLine(), config.getMatchFormat())) {
                    countDownLatch.countDown();
                }
            }

            public void onComplete() {
                countDownLatch.countDown();
            }
        });
        if (!countDownLatch.await(config.getMaxWaitLogSeconds().intValue(), TimeUnit.SECONDS)) {
            logger.warn("Didn't find log line in a timely fashion, continuing");
        }
    }

    private static Map<Integer, Integer> getMappedPorts(Ports containerPorts) {
        HashMap<Integer, Integer> ports = new HashMap<Integer, Integer>();
        for (Map.Entry m : containerPorts.getBindings().entrySet()) {
            ports.put(((ExposedPort)m.getKey()).getPort(), Integer.valueOf(((Ports.Binding[])m.getValue())[0].getHostPortSpec()));
        }
        return ports;
    }
}

