/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.v2;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Container
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Container.class);
    private final CreateContainerResponse containerInfo;
    private final Map<Integer, Integer> targetPortToHostPortLookup;
    private final String dockerHost;
    private final DockerClient client;
    private Boolean isClosed = false;

    public String readLogsFully(Integer waitTimeSeconds) throws InterruptedException {
        LogContainerCmd logContainerCmd = this.client.logContainerCmd(this.containerInfo.getId()).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true));
        final StringBuilder stringBuilder = new StringBuilder();
        LogContainerResultCallback resultCallback = new LogContainerResultCallback(){

            public void onNext(Frame item) {
                stringBuilder.append(item.toString() + System.lineSeparator());
            }
        };
        logContainerCmd.exec((ResultCallback)resultCallback);
        resultCallback.awaitCompletion((long)waitTimeSeconds.intValue(), TimeUnit.SECONDS);
        return stringBuilder.toString();
    }

    public WaitContainerResultCallback waitForCompletion() {
        WaitContainerResultCallback waitContainerResultCallback = new WaitContainerResultCallback();
        this.client.waitContainerCmd(this.getContainerInfo().getId()).exec((ResultCallback)waitContainerResultCallback);
        return waitContainerResultCallback;
    }

    @Override
    public void close() {
        try {
            try {
                this.client.stopContainerCmd(this.containerInfo.getId()).withTimeout(Integer.valueOf(30)).exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client.removeContainerCmd(this.containerInfo.getId()).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed.booleanValue()) {
            this.close();
        }
    }

    public CreateContainerResponse getContainerInfo() {
        return this.containerInfo;
    }

    public Map<Integer, Integer> getTargetPortToHostPortLookup() {
        return this.targetPortToHostPortLookup;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public DockerClient getClient() {
        return this.client;
    }

    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CreateContainerResponse this$containerInfo = this.getContainerInfo();
        CreateContainerResponse other$containerInfo = other.getContainerInfo();
        if (this$containerInfo == null ? other$containerInfo != null : !this$containerInfo.equals(other$containerInfo)) {
            return false;
        }
        Map<Integer, Integer> this$targetPortToHostPortLookup = this.getTargetPortToHostPortLookup();
        Map<Integer, Integer> other$targetPortToHostPortLookup = other.getTargetPortToHostPortLookup();
        if (this$targetPortToHostPortLookup == null ? other$targetPortToHostPortLookup != null : !((Object)this$targetPortToHostPortLookup).equals(other$targetPortToHostPortLookup)) {
            return false;
        }
        String this$dockerHost = this.getDockerHost();
        String other$dockerHost = other.getDockerHost();
        if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
            return false;
        }
        DockerClient this$client = this.getClient();
        DockerClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        Boolean this$isClosed = this.getIsClosed();
        Boolean other$isClosed = other.getIsClosed();
        return !(this$isClosed == null ? other$isClosed != null : !((Object)this$isClosed).equals(other$isClosed));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CreateContainerResponse $containerInfo = this.getContainerInfo();
        result = result * 59 + ($containerInfo == null ? 43 : $containerInfo.hashCode());
        Map<Integer, Integer> $targetPortToHostPortLookup = this.getTargetPortToHostPortLookup();
        result = result * 59 + ($targetPortToHostPortLookup == null ? 43 : ((Object)$targetPortToHostPortLookup).hashCode());
        String $dockerHost = this.getDockerHost();
        result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
        DockerClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        Boolean $isClosed = this.getIsClosed();
        result = result * 59 + ($isClosed == null ? 43 : ((Object)$isClosed).hashCode());
        return result;
    }

    public String toString() {
        return "Container(containerInfo=" + this.getContainerInfo() + ", targetPortToHostPortLookup=" + this.getTargetPortToHostPortLookup() + ", dockerHost=" + this.getDockerHost() + ", client=" + this.getClient() + ", isClosed=" + this.getIsClosed() + ")";
    }

    @ConstructorProperties(value={"containerInfo", "targetPortToHostPortLookup", "dockerHost", "client"})
    public Container(CreateContainerResponse containerInfo, Map<Integer, Integer> targetPortToHostPortLookup, String dockerHost, DockerClient client) {
        this.containerInfo = containerInfo;
        this.targetPortToHostPortLookup = targetPortToHostPortLookup;
        this.dockerHost = dockerHost;
        this.client = client;
    }
}

