/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical;

import com.google.common.base.Splitter;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.RegistryAuth;
import io.paradoxical.Container;
import io.paradoxical.DockerClientConfig;
import io.paradoxical.EnvironmentVar;
import io.paradoxical.ExistingContainer;
import io.paradoxical.LogMatcher;
import io.paradoxical.MappedPort;
import io.paradoxical.PortGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DockerCreator {
    private static final Logger logger = LoggerFactory.getLogger(DockerCreator.class);

    public static Container build(DockerClientConfig config) throws InterruptedException, DockerException {
        return new DockerCreator().create(config);
    }

    public static List<ExistingContainer> findContainers(String prefixedWith) throws InterruptedException, DockerException {
        DockerClient dockerClient = DockerCreator.defaultClient();
        return DockerCreator.findContainers(dockerClient, prefixedWith);
    }

    public static List<ExistingContainer> findContainers(DockerClient dockerClient, String prefixedWith) throws InterruptedException, DockerException {
        List allContainers = dockerClient.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers((boolean)true)});
        ArrayList<ExistingContainer> foundContainers = new ArrayList<ExistingContainer>();
        for (com.spotify.docker.client.messages.Container container : allContainers) {
            if (!DockerCreator.containerStartsWith(container, prefixedWith)) continue;
            ContainerInfo containerInfo = dockerClient.inspectContainer(container.id());
            ExistingContainer containerMeta = new ExistingContainer(containerInfo, dockerClient);
            foundContainers.add(containerMeta);
        }
        return foundContainers;
    }

    private static boolean containerStartsWith(com.spotify.docker.client.messages.Container container, String prefixedWith) {
        for (String s : container.names()) {
            if (!s.substring(1, s.length()).startsWith(prefixedWith)) continue;
            return true;
        }
        return false;
    }

    public Container create(DockerClientConfig config) throws DockerException, InterruptedException {
        HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
        for (Integer transientPort : config.getTransientPorts()) {
            portBindings.put(transientPort.toString(), Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)PortGenerator.getNextAvailablePort())));
        }
        for (MappedPort mappedPort : config.getMappedPorts()) {
            portBindings.put(mappedPort.getHostPort().toString(), Collections.singletonList(PortBinding.of((String)"0.0.0.0", (String)mappedPort.getContainerPort().toString())));
        }
        HostConfig hostConfig = HostConfig.builder().portBindings(portBindings).lxcConf(new HostConfig.LxcConfParameter[]{new HostConfig.LxcConfParameter(){

            public String key() {
                return "icc";
            }

            public String value() {
                return "false";
            }
        }}).build();
        ContainerConfig.Builder configBuilder = ContainerConfig.builder().hostConfig(hostConfig).image(config.getImageName()).env(this.getEnvVars(config.getEnvVars())).exposedPorts(this.getPorts(config.getTransientPorts()));
        if (config.getArguments() != null) {
            configBuilder.cmd(Splitter.on((char)' ').splitToList((CharSequence)config.getArguments()));
        }
        this.addCustomConfigs(configBuilder);
        ContainerConfig container = configBuilder.build();
        DockerClient client = DockerCreator.createDockerClient(config);
        try {
            if (config.isPullAlways()) {
                client.pull(container.image());
            } else {
                client.inspectImage(container.image());
            }
        }
        catch (Exception e) {
            client.pull(container.image());
        }
        ContainerCreation createdContainer = client.createContainer(container, config.getContainerName());
        client.startContainer(createdContainer.id());
        if (!StringUtils.isEmpty((String)config.getWaitForLogLine())) {
            this.waitForLogInContainer(createdContainer, client, config);
        }
        ContainerInfo containerInfo = client.inspectContainer(createdContainer.id());
        HashMap<Integer, Integer> targetPortToHostPortLookup = new HashMap<Integer, Integer>();
        for (Integer port : config.getTransientPorts()) {
            targetPortToHostPortLookup.put(port, Integer.parseInt(((PortBinding)((List)containerInfo.networkSettings().ports().get((Object)(port + "/tcp"))).get(0)).hostPort()));
        }
        return new Container(containerInfo, targetPortToHostPortLookup, client.getHost(), client);
    }

    private List<String> getEnvVars(List<EnvironmentVar> envVars) {
        return EnvironmentVar.asEnvVars(envVars);
    }

    private String[] getPorts(List<Integer> ports) {
        HashSet<String> portsSet = new HashSet<String>();
        for (Integer port : ports) {
            portsSet.add(port.toString());
        }
        return portsSet.toArray(new String[0]);
    }

    protected void addCustomConfigs(ContainerConfig.Builder configBuilder) {
    }

    protected void waitForLogInContainer(final ContainerCreation createdContainer, final DockerClient client, final DockerClientConfig config) throws DockerException, InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread threadHack = new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                String log = "";
                LogStream logs = null;
                try {
                    logs = client.attachContainer(createdContainer.id(), new DockerClient.AttachParameter[]{DockerClient.AttachParameter.LOGS, DockerClient.AttachParameter.STREAM, DockerClient.AttachParameter.STDOUT, DockerClient.AttachParameter.STDERR});
                }
                catch (DockerException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                do {
                    if ((System.currentTimeMillis() - start) / 1000L > (long)config.getMaxWaitLogSeconds().intValue()) {
                        return;
                    }
                    if (!logs.hasNext()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    LogMessage logMessage = (LogMessage)logs.next();
                    ByteBuffer buffer = logMessage.content();
                    byte[] bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                    log = log + new String(bytes);
                } while (!LogMatcher.matches(log, config.getWaitForLogLine(), config.getMatchFormat()));
                countDownLatch.countDown();
            }
        });
        threadHack.setDaemon(true);
        threadHack.start();
        if (!countDownLatch.await(config.getMaxWaitLogSeconds().intValue(), TimeUnit.SECONDS)) {
            logger.warn("Log line never appeared in a timeline manner, attempting to continue");
        }
    }

    public static DockerClient defaultClient() {
        return DockerCreator.createDockerClient(DockerClientConfig.builder().build());
    }

    protected static DockerClient createDockerClient(DockerClientConfig config) {
        RegistryAuth registryAuth = DockerCreator.getRegistryAuth(config);
        try {
            if (registryAuth != null) {
                return DefaultDockerClient.fromEnv().registryAuth(registryAuth).build();
            }
            return DefaultDockerClient.fromEnv().build();
        }
        catch (DockerCertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static RegistryAuth getRegistryAuth(DockerClientConfig config) {
        try {
            String[] segments = config.getImageName().split("\\/");
            if (segments.length > 0) {
                try {
                    return RegistryAuth.fromDockerConfig((String)segments[0]).build();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }
}

