/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical;

import com.google.common.base.Splitter;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificateException;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.PortBinding;
import io.paradoxical.Container;
import io.paradoxical.DockerClientConfig;
import io.paradoxical.EnvironmentVar;
import io.paradoxical.MappedPort;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class DockerCreator {
    private static final Random random = new Random();

    public static Container build(DockerClientConfig config) throws InterruptedException, DockerException, DockerCertificateException {
        return new DockerCreator().create(config);
    }

    public Container create(DockerClientConfig config) throws DockerCertificateException, DockerException, InterruptedException {
        HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
        for (Integer port : config.getTransientPorts()) {
            portBindings.put(port.toString(), Collections.singletonList(PortBinding.of((String)"0.0.0.0", (int)(random.nextInt(30000) + 15000))));
        }
        for (MappedPort mappedPort : config.getMappedPorts()) {
            portBindings.put(mappedPort.getHostPort().toString(), Collections.singletonList(PortBinding.of((String)"0.0.0.0", (String)mappedPort.getContainerPort().toString())));
        }
        HostConfig hostConfig = HostConfig.builder().portBindings(portBindings).build();
        ContainerConfig.Builder configBuilder = ContainerConfig.builder().hostConfig(hostConfig).image(config.getImageName()).env(this.getEnvVars(config.getEnvVars())).networkDisabled(Boolean.valueOf(false)).exposedPorts(this.getPorts(config.getTransientPorts()));
        if (config.getArguments() != null) {
            configBuilder.cmd(Splitter.on((char)' ').splitToList((CharSequence)config.getArguments()));
        }
        this.addCustomConfigs(configBuilder);
        ContainerConfig container = configBuilder.build();
        DockerClient client = this.createDockerClient(config);
        try {
            if (config.isPullAlways()) {
                client.pull(configBuilder.image());
            } else {
                client.inspectImage(configBuilder.image());
            }
        }
        catch (Exception e) {
            client.pull(configBuilder.image());
        }
        ContainerCreation createdContainer = client.createContainer(container);
        client.startContainer(createdContainer.id());
        if (!StringUtils.isEmpty((String)config.getWaitForLogLine())) {
            this.waitForLogInContainer(createdContainer, client, config.getWaitForLogLine());
        }
        ContainerInfo containerInfo = client.inspectContainer(createdContainer.id());
        HashMap<Integer, Integer> targetPortToHostPortLookup = new HashMap<Integer, Integer>();
        for (Integer port : config.getTransientPorts()) {
            targetPortToHostPortLookup.put(port, Integer.parseInt(((PortBinding)((List)containerInfo.networkSettings().ports().get(port + "/tcp")).get(0)).hostPort()));
        }
        return new Container(containerInfo, targetPortToHostPortLookup, client.getHost(), client);
    }

    private List<String> getEnvVars(List<EnvironmentVar> envVars) {
        ArrayList<String> vars = new ArrayList<String>();
        for (EnvironmentVar envVar : envVars) {
            vars.add(envVar.getEnvVarName() + "=" + envVar.getEnvVarValue());
        }
        return vars;
    }

    private String[] getPorts(List<Integer> ports) {
        HashSet<String> portsSet = new HashSet<String>();
        for (Integer port : ports) {
            portsSet.add(port.toString());
        }
        return portsSet.toArray(new String[0]);
    }

    protected void addCustomConfigs(ContainerConfig.Builder configBuilder) {
    }

    protected void waitForLogInContainer(ContainerCreation createdContainer, DockerClient client, String waitForLog) throws DockerException, InterruptedException {
        byte[] bytes;
        String log;
        LogStream logs = client.logs(createdContainer.id(), new DockerClient.LogsParam[]{DockerClient.LogsParam.follow(), DockerClient.LogsParam.stdout()});
        do {
            LogMessage logMessage = (LogMessage)logs.next();
            ByteBuffer buffer = logMessage.content();
            bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
        } while (!(log = new String(bytes)).contains(waitForLog));
    }

    protected DockerClient createDockerClient(DockerClientConfig config) {
        if (this.isUnix() || System.getenv("DOCKER_HOST") != null) {
            try {
                return DefaultDockerClient.fromEnv().build();
            }
            catch (DockerCertificateException e) {
                System.err.println(e.getMessage());
            }
        }
        DockerCertificates dockerCertificates = null;
        try {
            String userHome = System.getProperty("user.home");
            dockerCertificates = new DockerCertificates(Paths.get(userHome, ".docker/machine/certs"));
        }
        catch (DockerCertificateException e) {
            System.err.println(e.getMessage());
        }
        String dockerMachineUrl = config.getDockerMachineUrl() == null ? DockerClientConfig.DOCKER_MACHINE_SERVICE_URL : config.getDockerMachineUrl();
        return DefaultDockerClient.builder().uri(URI.create(dockerMachineUrl)).dockerCertificates(dockerCertificates).build();
    }

    protected boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("nix") || os.contains("nux") || os.contains("aix");
    }
}

