/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.EvaluationAbortException;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.PathTokenFactory;
import com.jayway.jsonpath.internal.path.RootPathToken;
import com.jayway.jsonpath.spi.json.JsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledPath
implements Path {
    private static final Logger logger = LoggerFactory.getLogger(CompiledPath.class);
    private final RootPathToken root;
    private final boolean isRootPath;

    public CompiledPath(RootPathToken root, boolean isRootPath) {
        this.root = root;
        this.isRootPath = isRootPath;
    }

    public boolean isRootPath() {
        return this.isRootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationContext evaluate(Object document, Object rootDocument, Configuration configuration, boolean forUpdate) {
        EvaluationContextImpl ctx;
        PathRef op;
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluating path: {}", (Object)this.toString());
        }
        PathRef pathRef = op = (ctx = new EvaluationContextImpl(this, rootDocument, configuration, forUpdate, rootDocument)).forUpdate() ? PathRef.createRoot(rootDocument) : PathRef.NO_OP;
        if (this.root.isFunctionPath()) {
            PathToken funcToken = this.root.chop();
            try {
                EvaluationContextImpl retCtx;
                this.root.evaluate("", op, document, ctx);
                Object arrayModel = ctx.getValue(false);
                if (!this.root.isPathDefinite() && this.isArrayOfArrays(ctx, arrayModel)) {
                    Object array = ctx.configuration().jsonProvider().createArray();
                    for (int i = 0; i < ctx.configuration().jsonProvider().length(arrayModel); ++i) {
                        Object model = ctx.configuration().jsonProvider().getArrayIndex(arrayModel, i);
                        EvaluationContextImpl valCtx = this.evaluateFunction(funcToken, model, configuration, rootDocument, op);
                        Object val = valCtx.getValue(false);
                        ctx.configuration().jsonProvider().setArrayIndex(array, i, val);
                    }
                    retCtx = this.createFunctionEvaluationContext(funcToken, rootDocument, configuration, rootDocument);
                    retCtx.addResult(this.root.getPathFragment(), op, array);
                } else {
                    retCtx = this.evaluateFunction(funcToken, arrayModel, configuration, rootDocument, op);
                }
                EvaluationContextImpl evaluationContextImpl = retCtx;
                return evaluationContextImpl;
            }
            catch (EvaluationAbortException abort) {
            }
            finally {
                this.root.append(funcToken);
            }
        } else {
            try {
                this.root.evaluate("", op, document, ctx);
                return ctx;
            }
            catch (EvaluationAbortException abort) {
                // empty catch block
            }
        }
        return ctx;
    }

    private boolean isArrayOfArrays(EvaluationContext ctx, Object model) {
        JsonProvider jsonProvider = ctx.configuration().jsonProvider();
        if (!jsonProvider.isArray(model)) {
            return false;
        }
        if (jsonProvider.length(model) <= 0) {
            return false;
        }
        Object item = jsonProvider.getArrayIndex(model, 0);
        return jsonProvider.isArray(item);
    }

    private EvaluationContextImpl evaluateFunction(PathToken funcToken, Object model, Configuration configuration, Object rootDocument, PathRef op) {
        EvaluationContextImpl newCtx = this.createFunctionEvaluationContext(funcToken, model, configuration, rootDocument);
        funcToken.evaluate("", op, model, newCtx);
        return newCtx;
    }

    private EvaluationContextImpl createFunctionEvaluationContext(PathToken funcToken, Object model, Configuration configuration, Object rootDocument) {
        RootPathToken newRoot = PathTokenFactory.createRootPathToken(this.root.getRootToken());
        newRoot.append(funcToken);
        CompiledPath newCPath = new CompiledPath(newRoot, true);
        return new EvaluationContextImpl(newCPath, model, configuration, false, rootDocument);
    }

    public EvaluationContext evaluate(Object document, Object rootDocument, Configuration configuration) {
        return this.evaluate(document, rootDocument, configuration, false);
    }

    public boolean isDefinite() {
        return this.root.isPathDefinite();
    }

    public boolean isFunctionPath() {
        return this.root.isFunctionPath();
    }

    public String toString() {
        return this.root.toString();
    }
}

