/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.EvaluationListener;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.internal.DefaultsImpl;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.function.JsonPathFunctionFactory;
import com.jayway.jsonpath.internal.function.MapJsonPathFunctionFactory;
import com.jayway.jsonpath.internal.function.PathFunction;
import com.jayway.jsonpath.internal.function.PathFunctionFactory;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static Defaults DEFAULTS = null;
    private final JsonProvider jsonProvider;
    private final MappingProvider mappingProvider;
    private final Set<Option> options;
    private final Collection<EvaluationListener> evaluationListeners;
    private final JsonPathFunctionFactory jsonPathFunctionFactory;

    public static synchronized void setDefaults(Defaults defaults) {
        DEFAULTS = defaults;
    }

    private static Defaults getEffectiveDefaults() {
        if (DEFAULTS == null) {
            return DefaultsImpl.INSTANCE;
        }
        return DEFAULTS;
    }

    private Configuration(JsonProvider jsonProvider, MappingProvider mappingProvider, EnumSet<Option> options, Collection<EvaluationListener> evaluationListeners, JsonPathFunctionFactory jsonPathFunctionFactory) {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(mappingProvider, "mappingProvider can not be null", new Object[0]);
        Utils.notNull(options, "setOptions can not be null", new Object[0]);
        Utils.notNull(evaluationListeners, "evaluationListeners can not be null", new Object[0]);
        Utils.notNull(jsonPathFunctionFactory, "jsonPathFunctionFactory can not be null", new Object[0]);
        this.jsonProvider = jsonProvider;
        this.mappingProvider = mappingProvider;
        this.options = Collections.unmodifiableSet(options);
        this.evaluationListeners = Collections.unmodifiableCollection(evaluationListeners);
        this.jsonPathFunctionFactory = jsonPathFunctionFactory;
    }

    public Configuration addEvaluationListeners(EvaluationListener ... evaluationListener) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(this.options).evaluationListener(evaluationListener).build();
    }

    public Configuration setEvaluationListeners(EvaluationListener ... evaluationListener) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(this.options).evaluationListener(evaluationListener).build();
    }

    public Collection<EvaluationListener> getEvaluationListeners() {
        return this.evaluationListeners;
    }

    public Configuration jsonProvider(JsonProvider newJsonProvider) {
        return Configuration.builder().jsonProvider(newJsonProvider).mappingProvider(this.mappingProvider).options(this.options).evaluationListener(this.evaluationListeners).build();
    }

    public JsonProvider jsonProvider() {
        return this.jsonProvider;
    }

    public Configuration mappingProvider(MappingProvider newMappingProvider) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(newMappingProvider).options(this.options).evaluationListener(this.evaluationListeners).build();
    }

    public MappingProvider mappingProvider() {
        return this.mappingProvider;
    }

    public JsonPathFunctionFactory pathFunctionFactory() {
        return this.jsonPathFunctionFactory;
    }

    public Configuration addOptions(Option ... options) {
        EnumSet<Option> opts = EnumSet.noneOf(Option.class);
        opts.addAll(this.options);
        opts.addAll(Arrays.asList(options));
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(opts).evaluationListener(this.evaluationListeners).build();
    }

    public Configuration setOptions(Option ... options) {
        return Configuration.builder().jsonProvider(this.jsonProvider).mappingProvider(this.mappingProvider).options(options).evaluationListener(this.evaluationListeners).build();
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean containsOption(Option option) {
        return this.options.contains((Object)option);
    }

    public static Configuration defaultConfiguration() {
        Defaults defaults = Configuration.getEffectiveDefaults();
        return Configuration.builder().jsonProvider(defaults.jsonProvider()).options(defaults.options()).build();
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Defaults {
        public JsonProvider jsonProvider();

        public Set<Option> options();

        public MappingProvider mappingProvider();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationBuilder {
        private static final JsonPathFunctionFactory DEFAULT_FUNCTION_FACTORY = new MapJsonPathFunctionFactory(PathFunctionFactory.FUNCTIONS);
        private JsonProvider jsonProvider;
        private MappingProvider mappingProvider;
        private EnumSet<Option> options = EnumSet.noneOf(Option.class);
        private Collection<EvaluationListener> evaluationListener = new ArrayList<EvaluationListener>();
        private JsonPathFunctionFactory jsonPathFunctionFactory = DEFAULT_FUNCTION_FACTORY;

        public ConfigurationBuilder jsonProvider(JsonProvider provider) {
            this.jsonProvider = provider;
            return this;
        }

        public ConfigurationBuilder mappingProvider(MappingProvider provider) {
            this.mappingProvider = provider;
            return this;
        }

        public ConfigurationBuilder options(Option ... flags) {
            if (flags.length > 0) {
                this.options.addAll(Arrays.asList(flags));
            }
            return this;
        }

        public ConfigurationBuilder options(Set<Option> options) {
            this.options.addAll(options);
            return this;
        }

        public ConfigurationBuilder evaluationListener(EvaluationListener ... listener) {
            this.evaluationListener = Arrays.asList(listener);
            return this;
        }

        public ConfigurationBuilder evaluationListener(Collection<EvaluationListener> listeners) {
            this.evaluationListener = listeners == null ? Collections.emptyList() : listeners;
            return this;
        }

        public ConfigurationBuilder pathFunctionFactory(JsonPathFunctionFactory jsonPathFunctionFactory) {
            this.jsonPathFunctionFactory = jsonPathFunctionFactory == null ? DEFAULT_FUNCTION_FACTORY : jsonPathFunctionFactory;
            return this;
        }

        public ConfigurationBuilder pathFunctions(Map<String, Class<? extends PathFunction>> functions) {
            this.jsonPathFunctionFactory = functions == null ? DEFAULT_FUNCTION_FACTORY : new MapJsonPathFunctionFactory(new HashMap<String, Class<? extends PathFunction>>(functions));
            return this;
        }

        public Configuration build() {
            if (this.jsonProvider == null || this.mappingProvider == null) {
                Defaults defaults = Configuration.getEffectiveDefaults();
                if (this.jsonProvider == null) {
                    this.jsonProvider = defaults.jsonProvider();
                }
                if (this.mappingProvider == null) {
                    this.mappingProvider = defaults.mappingProvider();
                }
            }
            return new Configuration(this.jsonProvider, this.mappingProvider, this.options, this.evaluationListener, this.jsonPathFunctionFactory);
        }
    }
}

