/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.function;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.function.JsonPathFunctionFactory;
import com.jayway.jsonpath.internal.function.PathFunction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJsonPathFunctionFactory
implements JsonPathFunctionFactory {
    private final Map<String, Class<? extends PathFunction>> pathFunctionMap;

    public MapJsonPathFunctionFactory(Map<String, Class<? extends PathFunction>> pathFunctionMap) {
        this.pathFunctionMap = pathFunctionMap;
    }

    @Override
    public PathFunction newFunction(String name) throws InvalidPathException {
        Class<? extends PathFunction> functionClazz = this.pathFunctionMap.get(name);
        if (functionClazz == null) {
            throw new InvalidPathException("Function with name: " + name + " does not exists.");
        }
        try {
            return functionClazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidPathException("Function of name: " + name + " cannot be created", e);
        }
    }
}

