/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.rabbitmq.client.Channel;
import io.paradoxical.rabbitmq.Exchange;
import io.paradoxical.rabbitmq.FilterAttributes;
import io.paradoxical.rabbitmq.Queue;
import io.paradoxical.rabbitmq.RabbitRawMessage;
import io.paradoxical.rabbitmq.connectionManagment.ExchangeUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.MDC;

public class ChannelInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ChannelInitializer.class);

    public static Queue initializeExchange(Channel channel, Exchange exchange, Queue queue) throws IOException {
        if (!StringUtils.isEmpty((CharSequence)exchange.getExchangeName())) {
            ExchangeUtils.declare(channel, exchange);
            exchange.getDlq().ifPresent(dlqExchange -> {
                try {
                    ExchangeUtils.declare(channel, dlqExchange);
                    if (dlqExchange.isDeclareQueueWithSameName()) {
                        ChannelInitializer.createAndBindQueue(channel, dlqExchange, dlqExchange.getDefaultQueue());
                        logger.with("dlq", dlqExchange).debug("Created dlq queue instance");
                    }
                }
                catch (IOException e) {
                    logger.error("Error declaring dql exchange", (Throwable)e);
                }
            });
            exchange.getRetryExchange().ifPresent(retryExchange -> {
                try {
                    ExchangeUtils.declare(channel, retryExchange);
                    ChannelInitializer.createAndBindQueue(channel, retryExchange, queue.getRetryQueue());
                }
                catch (IOException e) {
                    logger.error("Error declaring retry exchange", (Throwable)e);
                }
            });
            ChannelInitializer.createAndBindQueue(channel, exchange, queue);
            return ChannelInitializer.bindQueueToRoutingKeys(channel, queue.getDeclaredName(), exchange, queue.getRoutingKeys());
        }
        ChannelInitializer.createAndBindQueue(channel, exchange, queue);
        return queue;
    }

    private static Queue createAndBindQueue(Channel channel, Exchange exchange, Queue queue) throws IOException {
        String declaredQueueName = ChannelInitializer.declareQueue(channel, exchange, queue);
        queue.setDeclaredName(declaredQueueName);
        ChannelInitializer.bindQueueToRoutingKeys(channel, queue.getDeclaredName(), exchange, queue.getRoutingKeys());
        return queue;
    }

    public static String declareQueue(Channel channel, Exchange exchange, Queue queue) throws IOException {
        String queueName = queue.getName();
        HashMap<String, String> args = new HashMap<String, String>();
        if (exchange.getDlq().isPresent()) {
            Exchange dlqExchange = exchange.getDlq().get();
            args.put("x-dead-letter-exchange", dlqExchange.getExchangeName());
        }
        return channel.queueDeclare(queueName, queue.getOptions().getDurable().booleanValue(), queue.getOptions().getExclusive().booleanValue(), queue.getOptions().getAutoDelete().booleanValue(), args).getQueue();
    }

    public static Queue bindQueueToRoutingKeys(Channel channel, String queueName, Exchange exchange, Optional<List<String>> optionalRoutes) throws IOException {
        List<String> routingKeys = optionalRoutes.orElse(Arrays.asList(exchange.getExchangeName()));
        for (String routingKey : routingKeys) {
            channel.queueBind(queueName, exchange.getExchangeName(), routingKey);
        }
        return new Queue(queueName, optionalRoutes);
    }

    public static UUID setupMessageContext(RabbitRawMessage rabbitRawMessage, Exchange exchange, Queue newQueue) throws IOException {
        UUID correlationId = UUID.fromString(rabbitRawMessage.getProperties().getCorrelationId());
        MDC.put((String)FilterAttributes.CORR_ID, (Object)correlationId);
        logger.debug(String.format("Got message message [%s] %s, exchange=%s, type=%s, queue=%s, routingKey=%s, listening_on=%s", correlationId, rabbitRawMessage.getEnvelope().getDeliveryTag(), exchange.getExchangeName(), exchange.getExchangeType().getExchangeTypeName(), newQueue.getName(), rabbitRawMessage.getEnvelope().getRoutingKey(), newQueue.getRoutingKeys()));
        return correlationId;
    }
}

