/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import io.paradoxical.rabbitmq.DlqExchange;
import io.paradoxical.rabbitmq.ExchangeOptions;
import io.paradoxical.rabbitmq.Queue;
import io.paradoxical.rabbitmq.RetryExchange;
import io.paradoxical.rabbitmq.RetryStrategy;
import java.util.Optional;

public class Exchange {
    private final Type exchangeType;
    private final String exchangeName;
    private final ExchangeOptions options = new ExchangeOptions();
    private Optional<Exchange> dlq = Optional.empty();
    private final Queue defaultQueue;
    private boolean declareQueueWithSameName;
    private Optional<RetryExchange> retryExchange = Optional.empty();

    public Exchange(Type exchange, String exchangeName) {
        this.exchangeType = exchange;
        this.exchangeName = exchangeName;
        this.defaultQueue = Queue.valueOf(this.getExchangeName()).withRoute(this.getExchangeName());
    }

    public Exchange(String name) {
        this(Type.Direct, name);
    }

    public Exchange withDlq(Exchange dlq) {
        this.dlq = Optional.of(dlq);
        return this;
    }

    public Exchange withRetryExchange(RetryStrategy strategy) {
        this.retryExchange = Optional.of(new RetryExchange(this, this.exchangeName + ".retry", strategy));
        return this;
    }

    public static DlqExchange asDlq(String name) {
        return new DlqExchange(name);
    }

    public Type getExchangeType() {
        return this.exchangeType;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public ExchangeOptions getOptions() {
        return this.options;
    }

    public Optional<Exchange> getDlq() {
        return this.dlq;
    }

    public Queue getDefaultQueue() {
        return this.defaultQueue;
    }

    public boolean isDeclareQueueWithSameName() {
        return this.declareQueueWithSameName;
    }

    public void setDeclareQueueWithSameName(boolean declareQueueWithSameName) {
        this.declareQueueWithSameName = declareQueueWithSameName;
    }

    public Optional<RetryExchange> getRetryExchange() {
        return this.retryExchange;
    }

    public static enum Type {
        Direct("direct"),
        Fanout("fanout"),
        Topic("topic"),
        Headers("headers");

        private final String exchangeTypeName;

        private Type(String exchangeName) {
            this.exchangeTypeName = exchangeName;
        }

        public String toString() {
            return "Type{exchangeTypeName='" + this.exchangeTypeName + '\'' + '}';
        }

        public String getExchangeTypeName() {
            return this.exchangeTypeName;
        }
    }
}

