/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import com.codahale.metrics.MetricRegistry;
import io.paradoxical.rabbitmq.DefaultSerializer;
import io.paradoxical.rabbitmq.QueueSerializer;
import java.util.Arrays;
import java.util.List;

public class ListenerOptions {
    private final QueueSerializer serializer;
    private final MetricRegistry metricRegistry;
    private final List<String> metricGroups;
    private final Integer maxRetries;
    public static final ListenerOptions Default = ListenerOptions.builder().build();

    public ListenerOptions(QueueSerializer serializer, MetricRegistry metricRegistry, List<String> metricGroups, Integer maxRetries) {
        this.serializer = serializer != null ? serializer : new DefaultSerializer();
        this.metricRegistry = metricRegistry;
        this.metricGroups = metricGroups;
        this.maxRetries = maxRetries == null ? 1 : maxRetries;
    }

    public static ListenerOptionsBuilder builder() {
        return new ListenerOptionsBuilder();
    }

    public QueueSerializer getSerializer() {
        return this.serializer;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public List<String> getMetricGroups() {
        return this.metricGroups;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListenerOptions)) {
            return false;
        }
        ListenerOptions other = (ListenerOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueueSerializer this$serializer = this.getSerializer();
        QueueSerializer other$serializer = other.getSerializer();
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        MetricRegistry this$metricRegistry = this.getMetricRegistry();
        MetricRegistry other$metricRegistry = other.getMetricRegistry();
        if (this$metricRegistry == null ? other$metricRegistry != null : !this$metricRegistry.equals(other$metricRegistry)) {
            return false;
        }
        List<String> this$metricGroups = this.getMetricGroups();
        List<String> other$metricGroups = other.getMetricGroups();
        if (this$metricGroups == null ? other$metricGroups != null : !((Object)this$metricGroups).equals(other$metricGroups)) {
            return false;
        }
        Integer this$maxRetries = this.getMaxRetries();
        Integer other$maxRetries = other.getMaxRetries();
        return !(this$maxRetries == null ? other$maxRetries != null : !((Object)this$maxRetries).equals(other$maxRetries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListenerOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueueSerializer $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        MetricRegistry $metricRegistry = this.getMetricRegistry();
        result = result * 59 + ($metricRegistry == null ? 43 : $metricRegistry.hashCode());
        List<String> $metricGroups = this.getMetricGroups();
        result = result * 59 + ($metricGroups == null ? 43 : ((Object)$metricGroups).hashCode());
        Integer $maxRetries = this.getMaxRetries();
        result = result * 59 + ($maxRetries == null ? 43 : ((Object)$maxRetries).hashCode());
        return result;
    }

    public String toString() {
        return "ListenerOptions(serializer=" + this.getSerializer() + ", metricRegistry=" + this.getMetricRegistry() + ", metricGroups=" + this.getMetricGroups() + ", maxRetries=" + this.getMaxRetries() + ")";
    }

    public static class ListenerOptionsBuilder {
        private QueueSerializer serializer;
        private MetricRegistry metricRegistry;
        private List<String> metricGroups;
        private Integer maxRetries;

        ListenerOptionsBuilder() {
        }

        public ListenerOptionsBuilder serializer(QueueSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public ListenerOptionsBuilder metricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public ListenerOptionsBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ListenerOptionsBuilder metricGroups(String ... metricGroups) {
            return this.metricGroups(Arrays.asList(metricGroups));
        }

        public ListenerOptionsBuilder metricGroups(List<String> metricGroups) {
            this.metricGroups = metricGroups;
            return this;
        }

        public ListenerOptions build() {
            return new ListenerOptions(this.serializer, this.metricRegistry, this.metricGroups, this.maxRetries);
        }
    }
}

