/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import io.paradoxical.rabbitmq.PublishingContext;
import java.time.Duration;

public class PublisherOptions {
    private PublishingContext context = new PublishingContext();
    private Duration messageTtl;
    public static final PublisherOptions Default = PublisherOptions.builder().context(new PublishingContext()).build();

    PublisherOptions(PublishingContext context, Duration messageTtl) {
        this.context = context;
        this.messageTtl = messageTtl;
    }

    public static PublisherOptionsBuilder builder() {
        return new PublisherOptionsBuilder();
    }

    public PublishingContext getContext() {
        return this.context;
    }

    public Duration getMessageTtl() {
        return this.messageTtl;
    }

    public void setContext(PublishingContext context) {
        this.context = context;
    }

    public void setMessageTtl(Duration messageTtl) {
        this.messageTtl = messageTtl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublisherOptions)) {
            return false;
        }
        PublisherOptions other = (PublisherOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublishingContext this$context = this.getContext();
        PublishingContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        Duration this$messageTtl = this.getMessageTtl();
        Duration other$messageTtl = other.getMessageTtl();
        return !(this$messageTtl == null ? other$messageTtl != null : !((Object)this$messageTtl).equals(other$messageTtl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublisherOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublishingContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        Duration $messageTtl = this.getMessageTtl();
        result = result * 59 + ($messageTtl == null ? 43 : ((Object)$messageTtl).hashCode());
        return result;
    }

    public String toString() {
        return "PublisherOptions(context=" + this.getContext() + ", messageTtl=" + this.getMessageTtl() + ")";
    }

    public static class PublisherOptionsBuilder {
        private PublishingContext context;
        private Duration messageTtl;

        PublisherOptionsBuilder() {
        }

        public PublisherOptionsBuilder context(PublishingContext context) {
            this.context = context;
            return this;
        }

        public PublisherOptionsBuilder messageTtl(Duration messageTtl) {
            this.messageTtl = messageTtl;
            return this;
        }

        public PublisherOptions build() {
            return new PublisherOptions(this.context, this.messageTtl);
        }

        public String toString() {
            return "PublisherOptions.PublisherOptionsBuilder(context=" + this.context + ", messageTtl=" + this.messageTtl + ")";
        }
    }
}

