/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import io.paradoxical.rabbitmq.DefaultSerializer;
import io.paradoxical.rabbitmq.Exchange;
import io.paradoxical.rabbitmq.PublisherExchange;
import io.paradoxical.rabbitmq.PublisherProvider;
import io.paradoxical.rabbitmq.QueueSerializer;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import io.paradoxical.rabbitmq.queues.EventBase;
import io.paradoxical.rabbitmq.queues.QueuePublisher;
import java.util.UUID;
import java.util.function.Supplier;
import javax.inject.Inject;

public class PublisherProviderImpl<T extends EventBase>
implements PublisherProvider<T> {
    private static final Logger logger = LoggerFactory.getLogger(PublisherProviderImpl.class);
    protected final ChannelProvider channelProvider;
    private final QueueSerializer serializer;
    private final Supplier<UUID> corrIdProvider;

    public PublisherProviderImpl(ChannelProvider channelProvider) {
        this(channelProvider, () -> {
            logger.warn("Message does not have a correlation id, auto generating one");
            return UUID.randomUUID();
        });
    }

    public PublisherProviderImpl(ChannelProvider channelProvider, Supplier<UUID> corrIdProvider) {
        this(channelProvider, corrIdProvider, new DefaultSerializer());
    }

    @Inject
    public PublisherProviderImpl(ChannelProvider channelProvider, Supplier<UUID> corrIdProvider, QueueSerializer serializer) {
        this.channelProvider = channelProvider;
        this.corrIdProvider = corrIdProvider;
        this.serializer = serializer;
    }

    @Override
    public QueuePublisher<T> forExchange(Exchange exchange, String route) {
        try {
            return new QueuePublisher(this.channelProvider, new PublisherExchange(exchange, route), this.corrIdProvider, this.serializer);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "Error creating queue publisher", new Object[0]);
            return null;
        }
    }
}

