/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import com.google.common.collect.Lists;
import io.paradoxical.rabbitmq.QueueOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Queue {
    public static final String ANONYMOUS_NAME = "";
    private QueueOptions options = new QueueOptions();
    private final String name;
    private String declaredName;
    private Optional<List<String>> routingKeys;

    public Queue getRetryQueue() {
        return this.clone(this.name + "-wait");
    }

    public Queue(String name, Optional<List<String>> routingKeys) {
        this.name = name;
        this.routingKeys = routingKeys;
    }

    public static Queue valueOf(String name) {
        return new Queue(name, Optional.empty());
    }

    public Queue withRoute(String route) {
        return this.withRoutes(route);
    }

    public Queue withOptions(QueueOptions options) {
        this.options = options;
        return this;
    }

    public Queue clone(String newName) {
        return new Queue(newName, this.routingKeys).withOptions(this.options);
    }

    public Queue withRoutes(String ... routes) {
        ArrayList routeList = Lists.newArrayList((Object[])routes);
        if (this.routingKeys.isPresent()) {
            this.routingKeys.get().addAll(routeList);
        } else {
            this.routingKeys = Optional.of(routeList);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaredName() {
        return this.declaredName;
    }

    public Optional<List<String>> getRoutingKeys() {
        return this.routingKeys;
    }

    public void setDeclaredName(String declaredName) {
        this.declaredName = declaredName;
    }

    public void setRoutingKeys(Optional<List<String>> routingKeys) {
        this.routingKeys = routingKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QueueOptions this$options = this.getOptions();
        QueueOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$declaredName = this.getDeclaredName();
        String other$declaredName = other.getDeclaredName();
        if (this$declaredName == null ? other$declaredName != null : !this$declaredName.equals(other$declaredName)) {
            return false;
        }
        Optional<List<String>> this$routingKeys = this.getRoutingKeys();
        Optional<List<String>> other$routingKeys = other.getRoutingKeys();
        return !(this$routingKeys == null ? other$routingKeys != null : !((Object)this$routingKeys).equals(other$routingKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Queue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueueOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $declaredName = this.getDeclaredName();
        result = result * 59 + ($declaredName == null ? 43 : $declaredName.hashCode());
        Optional<List<String>> $routingKeys = this.getRoutingKeys();
        result = result * 59 + ($routingKeys == null ? 43 : ((Object)$routingKeys).hashCode());
        return result;
    }

    public String toString() {
        return "Queue(options=" + this.getOptions() + ", name=" + this.getName() + ", declaredName=" + this.getDeclaredName() + ", routingKeys=" + this.getRoutingKeys() + ")";
    }

    public QueueOptions getOptions() {
        return this.options;
    }

    private void setOptions(QueueOptions options) {
        this.options = options;
    }
}

