/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import io.paradoxical.rabbitmq.Exchange;
import io.paradoxical.rabbitmq.Queue;
import java.util.Arrays;
import java.util.List;

public class QueueConfiguration {
    private final Exchange exchange;
    private final List<Queue> queues;

    public QueueConfiguration(Exchange exchange, List<Queue> queues) {
        this.exchange = exchange;
        this.queues = queues;
    }

    public QueueConfiguration(Exchange exchange, Queue ... queues) {
        this.exchange = exchange;
        this.queues = Arrays.asList(queues);
    }

    public QueueConfiguration(Exchange exchange) {
        this.exchange = exchange;
        this.queues = Arrays.asList(Queue.valueOf(exchange.getExchangeName()));
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public List<Queue> getQueues() {
        return this.queues;
    }
}

