/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import com.google.common.base.Strings;
import io.paradoxical.rabbitmq.QueueNameException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class QueueNameBuilder {
    private QueueNameBuilder() {
    }

    public static String buildQueueName(String queueName, int version, Class<?> eventType) throws QueueNameException {
        QueueNameBuilder.eventTypePresent(eventType);
        return QueueNameBuilder.buildQueueName(queueName, version, QueueNameBuilder.camelCaseJoiner(eventType.getSimpleName()));
    }

    public static String buildQueueName(String queueName, String semantic, int version, Class<?> eventType) throws QueueNameException {
        return QueueNameBuilder.buildQueueName(queueName + "-" + semantic, version, eventType);
    }

    public static String buildQueueName(String queueName, String semantic, int version, String eventType) throws QueueNameException {
        return QueueNameBuilder.buildQueueName(queueName + "-" + semantic, version, eventType);
    }

    public static String buildQueueName(String queueName, int version, String eventType) throws QueueNameException {
        QueueNameBuilder.versionOneOrGreater(version);
        QueueNameBuilder.eventTypePresent(eventType);
        return "consumer." + QueueNameBuilder.getQueueName(queueName) + ".v" + version + "." + eventType.toLowerCase();
    }

    public static String buildTestQueueName(String queueName) throws QueueNameException {
        return "consumer.test-" + QueueNameBuilder.getQueueName(queueName);
    }

    public static String buildTestQueueName() throws QueueNameException {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        return QueueNameBuilder.camelCaseJoiner(QueueNameBuilder.buildTestQueueName(ste[2].getMethodName()));
    }

    private static String getQueueName(String queueName) throws QueueNameException {
        if (Strings.isNullOrEmpty((String)queueName)) {
            throw new QueueNameException("Queue name is required.");
        }
        return queueName.replaceAll("\\s+", "-").toLowerCase();
    }

    private static void versionOneOrGreater(int version) throws QueueNameException {
        if (version <= 0) {
            throw new QueueNameException("Version was " + version + ". Version must be 1 or later.");
        }
    }

    private static void eventTypePresent(Class<?> eventType) throws QueueNameException {
        if (eventType == null) {
            throw new QueueNameException("Event type is required.");
        }
    }

    private static void eventTypePresent(String eventType) throws QueueNameException {
        if (Strings.isNullOrEmpty((String)eventType)) {
            throw new QueueNameException("Event type is required.");
        }
    }

    private static String camelCaseJoiner(String camelCase) {
        List<String> camelCaseSplit = Arrays.asList(camelCase.split("(?=[A-Z])"));
        return camelCaseSplit.stream().collect(Collectors.joining("-"));
    }
}

