/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import io.paradoxical.rabbitmq.Exchange;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public class RabbitRawMessage {
    final String consumerTag;
    final Envelope envelope;
    final AMQP.BasicProperties properties;
    final byte[] body;
    final Exchange exchange;

    @ConstructorProperties(value={"consumerTag", "envelope", "properties", "body", "exchange"})
    public RabbitRawMessage(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body, Exchange exchange) {
        this.consumerTag = consumerTag;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
        this.exchange = exchange;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public AMQP.BasicProperties getProperties() {
        return this.properties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitRawMessage)) {
            return false;
        }
        RabbitRawMessage other = (RabbitRawMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$consumerTag = this.getConsumerTag();
        String other$consumerTag = other.getConsumerTag();
        if (this$consumerTag == null ? other$consumerTag != null : !this$consumerTag.equals(other$consumerTag)) {
            return false;
        }
        Envelope this$envelope = this.getEnvelope();
        Envelope other$envelope = other.getEnvelope();
        if (this$envelope == null ? other$envelope != null : !this$envelope.equals(other$envelope)) {
            return false;
        }
        AMQP.BasicProperties this$properties = this.getProperties();
        AMQP.BasicProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        Exchange this$exchange = this.getExchange();
        Exchange other$exchange = other.getExchange();
        return !(this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitRawMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $consumerTag = this.getConsumerTag();
        result = result * 59 + ($consumerTag == null ? 43 : $consumerTag.hashCode());
        Envelope $envelope = this.getEnvelope();
        result = result * 59 + ($envelope == null ? 43 : $envelope.hashCode());
        AMQP.BasicProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        Exchange $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        return result;
    }

    public String toString() {
        return "RabbitRawMessage(consumerTag=" + this.getConsumerTag() + ", envelope=" + this.getEnvelope() + ", properties=" + this.getProperties() + ", body=" + Arrays.toString(this.getBody()) + ", exchange=" + this.getExchange() + ")";
    }
}

