/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.connectionManagment;

public class ChannelOptions {
    public static final Integer NO_MAX_RETRY_ATTEMPTS_VALUE = -1;
    private final Integer prefetchCount;
    private final Integer heartbeatIntervalInSec;
    private final Integer retryIntervalSeconds;
    private final Integer maxRetryAttempts;
    public static final ChannelOptions Default = ChannelOptions.builder().prefetchCount(8).heartbeatIntervalInSec(30).retryIntervalSeconds(3).maxRetryAttempts(NO_MAX_RETRY_ATTEMPTS_VALUE).build();

    public ChannelOptions(Integer prefetchCount, Integer heartbeatIntervalInSec, Integer retryBackoffIntervalSeconds, Integer maxRetryAttempts) {
        this.prefetchCount = prefetchCount == null ? Default.getPrefetchCount() : prefetchCount;
        this.heartbeatIntervalInSec = heartbeatIntervalInSec == null ? Default.getHeartbeatIntervalInSec() : heartbeatIntervalInSec;
        this.retryIntervalSeconds = retryBackoffIntervalSeconds == null ? Default.getRetryIntervalSeconds() : retryBackoffIntervalSeconds;
        this.maxRetryAttempts = maxRetryAttempts == null ? Default.getMaxRetryAttempts() : maxRetryAttempts;
    }

    public static ChannelOptionsBuilder builder() {
        return new ChannelOptionsBuilder();
    }

    public Integer getPrefetchCount() {
        return this.prefetchCount;
    }

    public Integer getHeartbeatIntervalInSec() {
        return this.heartbeatIntervalInSec;
    }

    public Integer getRetryIntervalSeconds() {
        return this.retryIntervalSeconds;
    }

    public Integer getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelOptions)) {
            return false;
        }
        ChannelOptions other = (ChannelOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$prefetchCount = this.getPrefetchCount();
        Integer other$prefetchCount = other.getPrefetchCount();
        if (this$prefetchCount == null ? other$prefetchCount != null : !((Object)this$prefetchCount).equals(other$prefetchCount)) {
            return false;
        }
        Integer this$heartbeatIntervalInSec = this.getHeartbeatIntervalInSec();
        Integer other$heartbeatIntervalInSec = other.getHeartbeatIntervalInSec();
        if (this$heartbeatIntervalInSec == null ? other$heartbeatIntervalInSec != null : !((Object)this$heartbeatIntervalInSec).equals(other$heartbeatIntervalInSec)) {
            return false;
        }
        Integer this$retryIntervalSeconds = this.getRetryIntervalSeconds();
        Integer other$retryIntervalSeconds = other.getRetryIntervalSeconds();
        if (this$retryIntervalSeconds == null ? other$retryIntervalSeconds != null : !((Object)this$retryIntervalSeconds).equals(other$retryIntervalSeconds)) {
            return false;
        }
        Integer this$maxRetryAttempts = this.getMaxRetryAttempts();
        Integer other$maxRetryAttempts = other.getMaxRetryAttempts();
        return !(this$maxRetryAttempts == null ? other$maxRetryAttempts != null : !((Object)this$maxRetryAttempts).equals(other$maxRetryAttempts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $prefetchCount = this.getPrefetchCount();
        result = result * 59 + ($prefetchCount == null ? 43 : ((Object)$prefetchCount).hashCode());
        Integer $heartbeatIntervalInSec = this.getHeartbeatIntervalInSec();
        result = result * 59 + ($heartbeatIntervalInSec == null ? 43 : ((Object)$heartbeatIntervalInSec).hashCode());
        Integer $retryIntervalSeconds = this.getRetryIntervalSeconds();
        result = result * 59 + ($retryIntervalSeconds == null ? 43 : ((Object)$retryIntervalSeconds).hashCode());
        Integer $maxRetryAttempts = this.getMaxRetryAttempts();
        result = result * 59 + ($maxRetryAttempts == null ? 43 : ((Object)$maxRetryAttempts).hashCode());
        return result;
    }

    public String toString() {
        return "ChannelOptions(prefetchCount=" + this.getPrefetchCount() + ", heartbeatIntervalInSec=" + this.getHeartbeatIntervalInSec() + ", retryIntervalSeconds=" + this.getRetryIntervalSeconds() + ", maxRetryAttempts=" + this.getMaxRetryAttempts() + ")";
    }

    public static class ChannelOptionsBuilder {
        private Integer prefetchCount;
        private Integer heartbeatIntervalInSec;
        private Integer retryIntervalSeconds;
        private Integer maxRetryAttempts;

        ChannelOptionsBuilder() {
        }

        public ChannelOptionsBuilder prefetchCount(Integer prefetchCount) {
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ChannelOptionsBuilder heartbeatIntervalInSec(Integer heartbeatIntervalInSec) {
            this.heartbeatIntervalInSec = heartbeatIntervalInSec;
            return this;
        }

        public ChannelOptionsBuilder retryIntervalSeconds(Integer retryIntervalSeconds) {
            this.retryIntervalSeconds = retryIntervalSeconds;
            return this;
        }

        public ChannelOptionsBuilder maxRetryAttempts(Integer maxRetryAttempts) {
            this.maxRetryAttempts = maxRetryAttempts;
            return this;
        }

        public ChannelOptions build() {
            return new ChannelOptions(this.prefetchCount, this.heartbeatIntervalInSec, this.retryIntervalSeconds, this.maxRetryAttempts);
        }

        public String toString() {
            return "ChannelOptions.ChannelOptionsBuilder(prefetchCount=" + this.prefetchCount + ", heartbeatIntervalInSec=" + this.heartbeatIntervalInSec + ", retryIntervalSeconds=" + this.retryIntervalSeconds + ", maxRetryAttempts=" + this.maxRetryAttempts + ")";
        }
    }
}

