/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.connectionManagment;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.paradoxical.rabbitmq.connectionManagment.ChannelOptions;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import io.paradoxical.rabbitmq.connectionManagment.Host;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeoutException;
import net.jodah.lyra.ConnectionOptions;
import net.jodah.lyra.Connections;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.config.RecoveryPolicies;
import net.jodah.lyra.config.RetryPolicy;
import net.jodah.lyra.util.Duration;

public class SimpleChannelProvider
implements ChannelProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleChannelProvider.class);
    private final Connection connection;
    private final ChannelOptions channelOptions;

    public SimpleChannelProvider(Host host) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException {
        this(host, ChannelOptions.Default);
    }

    public SimpleChannelProvider(Host host, ChannelOptions channelOptions) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setUri(host.getUri());
        this.channelOptions = channelOptions;
        this.connection = SimpleChannelProvider.setupConnection(connectionFactory.getUsername(), connectionFactory.getPassword(), connectionFactory.getVirtualHost(), connectionFactory.getHost(), connectionFactory.getPort(), channelOptions);
    }

    public SimpleChannelProvider(String userName, String password, String virtualHost, Address[] contactPoints) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException {
        this(userName, password, virtualHost, contactPoints, ChannelOptions.Default);
    }

    public SimpleChannelProvider(String userName, String password, String virtualHost, Address[] contactPoints, ChannelOptions channelOptions) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException {
        this.channelOptions = channelOptions;
        this.connection = SimpleChannelProvider.setupConnection(userName, password, virtualHost, contactPoints, channelOptions);
    }

    @Override
    public Channel getChannel() {
        try {
            Channel channel = this.connection.createChannel();
            channel.basicQos(this.channelOptions.getPrefetchCount().intValue());
            return channel;
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Error getting channel", new Object[0]);
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    private static Connection setupConnection(String userName, String password, String virtualHost, String host, int port, ChannelOptions channelOptions) throws IOException {
        return SimpleChannelProvider.setupConnection(userName, password, virtualHost, new Address[]{new Address(host, port)}, channelOptions);
    }

    private static Connection setupConnection(String userName, String password, String virtualHost, Address[] contactPoints, ChannelOptions channelOptions) throws IOException {
        Config config = new Config().withRecoveryPolicy(RecoveryPolicies.recoverAlways().withInterval(Duration.seconds((long)channelOptions.getRetryIntervalSeconds().intValue()))).withRetryPolicy(new RetryPolicy().withInterval(Duration.seconds((long)channelOptions.getRetryIntervalSeconds().intValue())).withMaxAttempts(channelOptions.getMaxRetryAttempts().intValue()));
        ConnectionOptions connectionOptions = new ConnectionOptions().withAddresses(contactPoints).withUsername(userName).withPassword(password).withVirtualHost(virtualHost).withRequestedHeartbeat(Duration.seconds((long)channelOptions.getHeartbeatIntervalInSec().intValue()));
        connectionOptions.getConnectionFactory().setAutomaticRecoveryEnabled(true);
        try {
            return Connections.create((ConnectionOptions)connectionOptions, (Config)config);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }
}

