/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import io.paradoxical.rabbitmq.metrics.MetricsEventManagerOptions;
import io.paradoxical.rabbitmq.metrics.delegators.DelegatedCounter;
import io.paradoxical.rabbitmq.metrics.delegators.DelegatedMeter;
import io.paradoxical.rabbitmq.metrics.delegators.DelegatedTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MetricsEventManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(MetricsEventManager.class);
    private static final Object lock = new Object();
    private final MetricRegistry metricRegistry;
    private final List<String> metricGroups;
    private final Function<T, Class<?>> classMapper;
    private final MetricsEventManagerOptions<T> options;

    public MetricsEventManager(MetricsEventManagerOptions<T> options) {
        this.options = options;
        this.metricRegistry = options.getMetricRegistry();
        this.metricGroups = options.getMetricGroups() == null ? Collections.emptyList() : options.getMetricGroups();
        this.classMapper = options.getClassMapper() != null ? options.getClassMapper() : this::getDefaultEventClassType;
    }

    private List<String> groupNames(String subName) {
        return this.metricGroups.stream().map(i -> MetricRegistry.name((String)i, (String[])new String[]{subName})).collect(Collectors.toList());
    }

    private void registerMetric(String fullName, Metric metric) {
        block2: {
            try {
                this.metricRegistry.register(fullName, metric);
            }
            catch (Throwable ex) {
                logger.warn(ex, "Error registering metric!", new Object[0]);
                if (!this.options.isThrowOnError()) break block2;
                throw ex;
            }
        }
    }

    private <M extends Metric> M queryRegistryForNamedMetric(String fullTimerName, Supplier<M> onDefault) {
        if (this.metricRegistry == null) {
            return (M)((Metric)onDefault.get());
        }
        if (this.metricRegistry.getMetrics().containsKey(fullTimerName)) {
            Metric metric = (Metric)this.metricRegistry.getMetrics().get(fullTimerName);
            try {
                return (M)metric;
            }
            catch (Exception ex) {
                logger.with("full-name", (Object)fullTimerName).warn("Metric already found, and is not of the expected type. Metric will not be used!");
                return (M)((Metric)onDefault.get());
            }
        }
        return null;
    }

    protected Class<?> getDefaultEventClassType(T item) {
        return item.getClass();
    }

    public DelegatedTimer getTimerByEventType(T item, String eventPrefix) {
        try {
            return new DelegatedTimer(this.getMetricByEventType(item, eventPrefix, Timer::new, Timer.class));
        }
        catch (Exception ex) {
            return new DelegatedTimer(Collections.emptyList());
        }
    }

    public DelegatedCounter getCounterByEventType(T item, String eventPrefix) {
        try {
            return new DelegatedCounter(this.getMetricByEventType(item, eventPrefix, Counter::new, Counter.class));
        }
        catch (Exception ex) {
            return new DelegatedCounter(Collections.emptyList());
        }
    }

    public DelegatedTimer getTimer(String subName) {
        try {
            List<Timer> metrics = this.getMetric(subName, Timer::new, Timer.class);
            return new DelegatedTimer(metrics);
        }
        catch (Throwable ex) {
            logger.warn(ex, "Error creating metric, returning default", new Object[0]);
            return new DelegatedTimer(Collections.emptyList());
        }
    }

    public DelegatedCounter getCounter(String subName) {
        try {
            List<Counter> metrics = this.getMetric(subName, Counter::new, Counter.class);
            return new DelegatedCounter(metrics);
        }
        catch (Throwable ex) {
            logger.warn(ex, "Error creating metric, returning default", new Object[0]);
            return new DelegatedCounter(Collections.emptyList());
        }
    }

    public DelegatedMeter getMeter(String subName) {
        try {
            List<Meter> metrics = this.getMetric(subName, Meter::new, Meter.class);
            return new DelegatedMeter(metrics);
        }
        catch (Throwable ex) {
            logger.warn(ex, "Error creating metric, returning default", new Object[0]);
            return new DelegatedMeter(Collections.emptyList());
        }
    }

    private <M extends Metric> List<M> getMetric(String subName, Supplier<M> onDefault, Class<M> clazz) {
        M mainMetric = this.getMetricThreadSafe(subName, onDefault, clazz);
        List subMetrics = this.groupNames(subName).stream().map(name -> this.getMetricThreadSafe((String)name, onDefault, clazz)).collect(Collectors.toList());
        ArrayList allMetrics = new ArrayList(subMetrics);
        allMetrics.add(mainMetric);
        return allMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Metric> M getMetricThreadSafe(String subName, Supplier<M> onDefault, Class<M> clazz) {
        String fullName = MetricRegistry.name((String)this.options.getSourceId(), (String[])new String[]{subName});
        Object metric = this.queryRegistryForNamedMetric(fullName, onDefault);
        if (metric != null && clazz.isAssignableFrom(metric.getClass())) {
            return metric;
        }
        Object object = lock;
        synchronized (object) {
            metric = this.queryRegistryForNamedMetric(fullName, onDefault);
            if (metric != null && clazz.isAssignableFrom(metric.getClass())) {
                return metric;
            }
            metric = (Metric)onDefault.get();
            this.registerMetric(fullName, (Metric)metric);
            return metric;
        }
    }

    private <M extends Metric> List<M> getMetricByEventType(T item, String prefix, Supplier<M> onDefault, Class<M> clazz) {
        try {
            Class<?> itemClass;
            try {
                itemClass = this.classMapper.apply(item);
            }
            catch (Throwable ex) {
                itemClass = item.getClass();
                logger.error("Error getting event class type, using default", ex);
            }
            return this.getMetric(prefix + "." + itemClass.getSimpleName(), onDefault, clazz);
        }
        catch (Throwable ex) {
            logger.error(ex, "Error creating metric by event type, returning default", new Object[0]);
            return Collections.emptyList();
        }
    }
}

