/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.metrics;

import com.codahale.metrics.MetricRegistry;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;

public class MetricsEventManagerOptions<T> {
    private final MetricRegistry metricRegistry;
    private final String sourceId;
    private final List<String> metricGroups;
    private final Function<T, Class<?>> classMapper;
    private boolean throwOnError = false;

    @ConstructorProperties(value={"metricRegistry", "sourceId", "metricGroups", "classMapper", "throwOnError"})
    MetricsEventManagerOptions(MetricRegistry metricRegistry, String sourceId, List<String> metricGroups, Function<T, Class<?>> classMapper, boolean throwOnError) {
        this.metricRegistry = metricRegistry;
        this.sourceId = sourceId;
        this.metricGroups = metricGroups;
        this.classMapper = classMapper;
        this.throwOnError = throwOnError;
    }

    public static <T> MetricsEventManagerOptionsBuilder<T> builder() {
        return new MetricsEventManagerOptionsBuilder();
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public List<String> getMetricGroups() {
        return this.metricGroups;
    }

    public Function<T, Class<?>> getClassMapper() {
        return this.classMapper;
    }

    public boolean isThrowOnError() {
        return this.throwOnError;
    }

    public void setThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsEventManagerOptions)) {
            return false;
        }
        MetricsEventManagerOptions other = (MetricsEventManagerOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metricRegistry = this.getMetricRegistry();
        MetricRegistry other$metricRegistry = other.getMetricRegistry();
        if (this$metricRegistry == null ? other$metricRegistry != null : !this$metricRegistry.equals(other$metricRegistry)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        List<String> this$metricGroups = this.getMetricGroups();
        List<String> other$metricGroups = other.getMetricGroups();
        if (this$metricGroups == null ? other$metricGroups != null : !((Object)this$metricGroups).equals(other$metricGroups)) {
            return false;
        }
        Function<T, Class<?>> this$classMapper = this.getClassMapper();
        Function<T, Class<?>> other$classMapper = other.getClassMapper();
        if (this$classMapper == null ? other$classMapper != null : !this$classMapper.equals(other$classMapper)) {
            return false;
        }
        return this.isThrowOnError() == other.isThrowOnError();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricsEventManagerOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metricRegistry = this.getMetricRegistry();
        result = result * 59 + ($metricRegistry == null ? 43 : $metricRegistry.hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        List<String> $metricGroups = this.getMetricGroups();
        result = result * 59 + ($metricGroups == null ? 43 : ((Object)$metricGroups).hashCode());
        Function<T, Class<?>> $classMapper = this.getClassMapper();
        result = result * 59 + ($classMapper == null ? 43 : $classMapper.hashCode());
        result = result * 59 + (this.isThrowOnError() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "MetricsEventManagerOptions(metricRegistry=" + this.getMetricRegistry() + ", sourceId=" + this.getSourceId() + ", metricGroups=" + this.getMetricGroups() + ", classMapper=" + this.getClassMapper() + ", throwOnError=" + this.isThrowOnError() + ")";
    }

    public static class MetricsEventManagerOptionsBuilder<T> {
        private MetricRegistry metricRegistry;
        private String sourceId;
        private List<String> metricGroups;
        private Function<T, Class<?>> classMapper;
        private boolean throwOnError;

        MetricsEventManagerOptionsBuilder() {
        }

        public MetricsEventManagerOptionsBuilder<T> metricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public MetricsEventManagerOptionsBuilder<T> sourceClass(Class sourceClass) {
            this.sourceId = sourceClass.getName();
            return this;
        }

        public MetricsEventManagerOptionsBuilder<T> sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public MetricsEventManagerOptionsBuilder<T> metricGroups(List<String> metricGroups) {
            this.metricGroups = metricGroups;
            return this;
        }

        public MetricsEventManagerOptionsBuilder<T> classMapper(Function<T, Class<?>> classMapper) {
            this.classMapper = classMapper;
            return this;
        }

        public MetricsEventManagerOptionsBuilder<T> throwOnError(boolean throwOnError) {
            this.throwOnError = throwOnError;
            return this;
        }

        public MetricsEventManagerOptions<T> build() {
            return new MetricsEventManagerOptions<T>(this.metricRegistry, this.sourceId, this.metricGroups, this.classMapper, this.throwOnError);
        }

        public String toString() {
            return "com.godaddy.domains.metrics.MetricsEventManagerOptions.MetricsEventManagerOptionsBuilder(metricRegistry=" + this.metricRegistry + ", sourceId=" + this.sourceId + ", metricGroups=" + this.metricGroups + ", classMapper=" + this.classMapper + ", throwOnError=" + this.throwOnError + ")";
        }
    }
}

