/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.queues;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingConsumer
extends DefaultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(BlockingConsumer.class);
    private final BlockingQueue<QueueingConsumer.Delivery> blockingQueue;

    public BlockingConsumer(Channel channel) {
        this(channel, new LinkedBlockingQueue<QueueingConsumer.Delivery>());
    }

    public BlockingConsumer(Channel channel, BlockingQueue<QueueingConsumer.Delivery> blockingQueue) {
        super(channel);
        this.blockingQueue = blockingQueue;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        try {
            this.blockingQueue.put(new QueueingConsumer.Delivery(envelope, properties, body));
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e, "Error putting message into blocking queue!", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public QueueingConsumer.Delivery nextDelivery(long timeoutMillis) throws InterruptedException {
        return this.blockingQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
    }
}

