/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.queues;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import io.paradoxical.rabbitmq.Endpoint;
import io.paradoxical.rabbitmq.Exchange;
import io.paradoxical.rabbitmq.ListenerBase;
import io.paradoxical.rabbitmq.ListenerOptions;
import io.paradoxical.rabbitmq.Queue;
import io.paradoxical.rabbitmq.SingleQueueConfiguration;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import io.paradoxical.rabbitmq.queues.BlockingConsumer;
import io.paradoxical.rabbitmq.queues.CallbackBasedQueueConsumer;
import io.paradoxical.rabbitmq.queues.EventBase;
import io.paradoxical.rabbitmq.queues.QueueEndpoint;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;

public abstract class BlockingQueueConsumerSyncBase<T extends EventBase>
extends ListenerBase<T>
implements AutoCloseable {
    protected final QueueEndpoint _endpoint;
    protected BlockingRmqConsumer consumer;
    private static final Logger logger = LoggerFactory.getLogger(CallbackBasedQueueConsumer.class);

    public BlockingQueueConsumerSyncBase(ChannelProvider channelProvider, SingleQueueConfiguration info, Class<T> target) throws IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        this(channelProvider, info, target, ListenerOptions.Default);
    }

    public BlockingQueueConsumerSyncBase(ChannelProvider channelProvider, SingleQueueConfiguration info, Class<T> target, ListenerOptions options) throws IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        super(target, channelProvider, options);
        this._endpoint = new QueueEndpoint(channelProvider, info.getExchange(), Collections.singletonList(info.getQueue()));
        this._endpoint.createChannel();
    }

    @Override
    protected Consumer getRmqConsumerType(Channel channel, Exchange exchange, Queue queue) {
        this.consumer = new BlockingRmqConsumer(new BlockingConsumer(channel), exchange, queue);
        return this.consumer.getConsumer();
    }

    @Override
    protected Endpoint getEndpoint() {
        return this._endpoint;
    }

    @Override
    public void close() throws Exception {
        this._endpoint.close();
        this.consumer = null;
    }

    final class BlockingRmqConsumer {
        private final BlockingConsumer consumer;
        private final Exchange exchange;
        private final Queue queue;

        @ConstructorProperties(value={"consumer", "exchange", "queue"})
        public BlockingRmqConsumer(BlockingConsumer consumer, Exchange exchange, Queue queue) {
            this.consumer = consumer;
            this.exchange = exchange;
            this.queue = queue;
        }

        public BlockingConsumer getConsumer() {
            return this.consumer;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public Queue getQueue() {
            return this.queue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockingRmqConsumer)) {
                return false;
            }
            BlockingRmqConsumer other = (BlockingRmqConsumer)o;
            BlockingConsumer this$consumer = this.getConsumer();
            BlockingConsumer other$consumer = other.getConsumer();
            if (this$consumer == null ? other$consumer != null : !((Object)((Object)this$consumer)).equals((Object)other$consumer)) {
                return false;
            }
            Exchange this$exchange = this.getExchange();
            Exchange other$exchange = other.getExchange();
            if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
                return false;
            }
            Queue this$queue = this.getQueue();
            Queue other$queue = other.getQueue();
            return !(this$queue == null ? other$queue != null : !((Object)this$queue).equals(other$queue));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockingConsumer $consumer = this.getConsumer();
            result = result * 59 + ($consumer == null ? 43 : ((Object)((Object)$consumer)).hashCode());
            Exchange $exchange = this.getExchange();
            result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
            Queue $queue = this.getQueue();
            result = result * 59 + ($queue == null ? 43 : ((Object)$queue).hashCode());
            return result;
        }

        public String toString() {
            return "BlockingQueueConsumerSyncBase.BlockingRmqConsumer(consumer=" + (Object)((Object)this.getConsumer()) + ", exchange=" + this.getExchange() + ", queue=" + this.getQueue() + ")";
        }
    }
}

