/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.queues;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.rabbitmq.client.QueueingConsumer;
import io.paradoxical.rabbitmq.EventProcessor;
import io.paradoxical.rabbitmq.ListenerOptions;
import io.paradoxical.rabbitmq.RabbitRawMessage;
import io.paradoxical.rabbitmq.SingleQueueConfiguration;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import io.paradoxical.rabbitmq.queues.BlockingQueueConsumerSyncBase;
import io.paradoxical.rabbitmq.queues.EventBase;
import io.paradoxical.rabbitmq.results.MessageResult;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class CallbackBasedQueueConsumer<T extends EventBase>
extends BlockingQueueConsumerSyncBase<T>
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CallbackBasedQueueConsumer.class);

    public CallbackBasedQueueConsumer(ChannelProvider channelProvider, SingleQueueConfiguration info, Class<T> target) throws IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        super(channelProvider, info, target);
    }

    public CallbackBasedQueueConsumer(ChannelProvider channelProvider, SingleQueueConfiguration info, Class<T> target, ListenerOptions options) throws IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        super(channelProvider, info, target, options);
    }

    public synchronized boolean pullNextBlockingRmqMessage(Duration timeout, EventProcessor<T> processor) {
        try {
            if (this.consumer != null) {
                QueueingConsumer.Delivery delivery = this.consumer.getConsumer().nextDelivery(timeout.toMillis());
                if (delivery == null) {
                    return false;
                }
                RabbitRawMessage rabbitRawMessage = new RabbitRawMessage(this.consumer.getConsumer().getConsumerTag(), delivery.getEnvelope(), delivery.getProperties(), delivery.getBody(), this.consumer.getExchange());
                this.deliveryHandler(this.consumer.getConsumer().getChannel(), this.consumer.getQueue(), rabbitRawMessage, msg -> {
                    MessageResult messageResult = processor.handleMessage(msg);
                    return CompletableFuture.completedFuture(messageResult);
                });
                return true;
            }
        }
        catch (Throwable ex) {
            logger.error(ex, "Error getting message!", new Object[0]);
        }
        return false;
    }
}

