/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.queues;

import com.rabbitmq.client.Channel;
import io.paradoxical.rabbitmq.Endpoint;
import io.paradoxical.rabbitmq.Exchange;
import io.paradoxical.rabbitmq.Queue;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueEndpoint
implements AutoCloseable,
Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(QueueEndpoint.class);
    private final ChannelProvider channelProvider;
    protected final Exchange exchange;
    private final List<Queue> queues;
    private Channel channel;

    public QueueEndpoint(ChannelProvider channelProvider, Exchange exchange, List<Queue> queues) throws IOException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        this.channelProvider = channelProvider;
        this.exchange = exchange;
        this.queues = queues;
    }

    protected Channel createChannel() throws IOException {
        this.close();
        this.channel = this.channelProvider.getChannel();
        return this.channel;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public void close() {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (Exception ex) {
            logger.error("Error closing endpoint", (Throwable)ex);
        }
    }

    @Override
    public List<Queue> getQueues() {
        return this.queues;
    }
}

