/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.queues;

import io.paradoxical.rabbitmq.Endpoint;
import io.paradoxical.rabbitmq.ListenerOptions;
import io.paradoxical.rabbitmq.Message;
import io.paradoxical.rabbitmq.QueueConfiguration;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import io.paradoxical.rabbitmq.queues.EventBase;
import io.paradoxical.rabbitmq.queues.QueueEndpoint;
import io.paradoxical.rabbitmq.queues.QueueListenerAsync;
import io.paradoxical.rabbitmq.results.MessageResult;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public abstract class QueueListenerSync<T extends EventBase>
extends QueueListenerAsync<T>
implements AutoCloseable {
    private final QueueEndpoint _endpoint;

    public QueueListenerSync(ChannelProvider channelProvider, QueueConfiguration info, Class<T> target) throws IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        this(channelProvider, info, target, ListenerOptions.Default);
    }

    public QueueListenerSync(ChannelProvider channelProvider, QueueConfiguration info, Class<T> target, ListenerOptions options) throws IOException, InterruptedException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        super(channelProvider, info, target, options);
        this._endpoint = new QueueEndpoint(channelProvider, info.getExchange(), info.getQueues());
        this._endpoint.createChannel();
    }

    @Override
    protected Endpoint getEndpoint() {
        return this._endpoint;
    }

    @Override
    public Future<MessageResult> onMessageAsync(Message<T> item) {
        return ConcurrentUtils.constantFuture((Object)((Object)this.onMessage((EventBase)item.getItem())));
    }

    public abstract MessageResult onMessage(T var1);

    @Override
    public void close() {
        this._endpoint.close();
    }
}

