/*
 * Decompiled with CFR 0.152.
 */
package io.paradoxical.rabbitmq.queues;

import com.godaddy.logging.Logger;
import com.godaddy.logging.LoggerFactory;
import com.rabbitmq.client.AMQP;
import io.paradoxical.rabbitmq.DefaultSerializer;
import io.paradoxical.rabbitmq.Exchange;
import io.paradoxical.rabbitmq.Publisher;
import io.paradoxical.rabbitmq.PublisherExchange;
import io.paradoxical.rabbitmq.PublisherOptions;
import io.paradoxical.rabbitmq.PublishingContext;
import io.paradoxical.rabbitmq.QueueSerializer;
import io.paradoxical.rabbitmq.connectionManagment.ChannelProvider;
import io.paradoxical.rabbitmq.connectionManagment.ExchangeUtils;
import io.paradoxical.rabbitmq.queues.EventBase;
import io.paradoxical.rabbitmq.queues.QueueEndpoint;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class QueuePublisher<T extends EventBase>
extends QueueEndpoint
implements Publisher<T> {
    private static final Logger logger = LoggerFactory.getLogger(QueuePublisher.class);
    private static ConcurrentHashMap<String, Boolean> cachedDeclaredExchangeNames = new ConcurrentHashMap();
    private final PublisherExchange publisherConfig;
    private final QueueSerializer serializer;
    private final Supplier<UUID> corrIdProvider;

    public QueuePublisher(ChannelProvider channelProvider, PublisherExchange exchange, Supplier<UUID> corrIdProvider) throws KeyManagementException, NoSuchAlgorithmException, IOException, URISyntaxException {
        this(channelProvider, exchange, corrIdProvider, new DefaultSerializer());
    }

    public QueuePublisher(ChannelProvider channelProvider, PublisherExchange exchange, Supplier<UUID> corrIdProvider, QueueSerializer serializer) throws URISyntaxException, KeyManagementException, NoSuchAlgorithmException, IOException {
        super(channelProvider, exchange.getExchange(), null);
        this.corrIdProvider = corrIdProvider;
        this.publisherConfig = exchange;
        this.serializer = serializer;
    }

    @Override
    public void publish(T item, PublisherOptions options) throws IOException {
        this.publishInternal(item, options);
    }

    @Override
    public void publish(T item) throws IOException {
        this.publishInternal(item, PublisherOptions.Default);
    }

    private void publishInternal(T item, PublisherOptions options) throws IOException {
        if (this.getChannel() == null) {
            this.createChannel();
        }
        this.declareExchange(this.exchange);
        Logger publishLoggingCtx = LoggerFactory.getLogger(QueuePublisher.class);
        publishLoggingCtx.with("exchange", (Object)this.getExchange().getExchangeName()).with("route", (Object)this.publisherConfig.getRoute());
        if (item == null) {
            publishLoggingCtx.warn("Attempting top publish null to queue!");
            return;
        }
        String dataType = item.getClass().getName();
        publishLoggingCtx = publishLoggingCtx.with("dataType", (Object)dataType);
        if (this.corrIdProvider != null && ((EventBase)item).getCorrelationId() == null) {
            ((EventBase)item).setCorrelationId(this.corrIdProvider.get());
        } else if (((EventBase)item).getCorrelationId() == null) {
            logger.warn("Message does not have a correlation id (auto generating one), and corrIdProvider was null.");
            ((EventBase)item).setCorrelationId(UUID.randomUUID());
        }
        publishLoggingCtx.with(item).with("publish-count", (Object)Optional.ofNullable(options.getContext()).map(PublishingContext::getPreviousPublishes).orElse(0)).info("Publishing item");
        AMQP.BasicProperties properties = this.getProperties(item, options);
        Exchange endpoint = this.getExchange();
        String routingKey = this.publisherConfig.getRoute();
        this.getChannel().basicPublish(endpoint.getExchangeName(), routingKey, properties, this.serialize(item));
        this.close();
    }

    private void declareExchange(Exchange exchange) throws IOException {
        String exchangeName = exchange.getExchangeName();
        if (!cachedDeclaredExchangeNames.containsKey(exchangeName)) {
            try {
                ExchangeUtils.declare(this.getChannel(), exchange);
            }
            catch (IOException ex) {
                logger.warn((Throwable)ex, "Error re-declaring exchange", new Object[0]);
                this.createChannel();
            }
            cachedDeclaredExchangeNames.put(exchangeName, true);
        }
    }

    protected AMQP.BasicProperties getProperties(T item, PublisherOptions options) {
        HashMap<String, Integer> headers = new HashMap<String, Integer>();
        int publishingAttempts = Optional.ofNullable(options.getContext()).flatMap(ctx -> Optional.ofNullable(ctx.getPreviousPublishes())).orElse(0) + 1;
        headers.put("X-PUBLISH-ATTEMPTS", publishingAttempts);
        return new AMQP.BasicProperties.Builder().correlationId(((EventBase)item).getCorrelationId().toString()).headers(headers).expiration(options.getMessageTtl() != null ? Long.toString(options.getMessageTtl().toMillis()) : null).build();
    }

    protected byte[] serialize(T item) throws IOException {
        try {
            return this.serializer.writeBytes(item);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

