/*
 * Copyright 2019 Carl Mastrangelo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.perfmark.impl;

import java.util.List;

public abstract class MarkHolder {

  public static final int NO_MAX_MARKS = -1;

  public abstract void start(long gen, String taskName, String tagName, long tagId, long nanoTime);

  public abstract void start(
      long gen, String taskName, Marker marker, String tagName, long tagId, long nanoTime);

  public abstract void start(long gen, String taskName, long nanoTime);

  public abstract void start(long gen, String taskName, Marker marker, long nanoTime);

  public abstract void link(long gen, long linkId);

  public abstract void link(long gen, long linkId, Marker marker);

  public abstract void stop(long gen, String taskName, String tagName, long tagId, long nanoTime);

  public abstract void stop(
      long gen, String taskName, Marker marker, String tagName, long tagId, long nanoTime);

  public abstract void stop(long gen, String taskName, long nanoTime);

  public abstract void stop(long gen, String taskName, Marker marker, long nanoTime);

  public abstract void event(
      long gen, String eventName, String tagName, long tagId, long nanoTime, long durationNanos);

  public abstract void event(
      long gen,
      String taskName,
      Marker marker,
      String tagName,
      long tagId,
      long nanoTime,
      long durationNanos);

  public abstract void event(long gen, String eventName, long nanoTime, long durationNanos);

  public abstract void event(
      long gen, String taskName, Marker marker, long nanoTime, long durationNanos);

  public abstract void resetForTest();

  public abstract List<Mark> read(boolean concurrentWrites);

  public int maxMarks() {
    return NO_MAX_MARKS;
  }

  protected MarkHolder() {}
}
