/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.Impl;
import io.perfmark.Link;
import io.perfmark.Tag;
import io.perfmark.impl.Generator;
import io.perfmark.impl.Marker;
import io.perfmark.impl.NoopGenerator;
import io.perfmark.impl.Storage;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class SecretPerfMarkImpl {
    SecretPerfMarkImpl() {
    }

    public static final class PerfMarkImpl
    extends Impl {
        private static final Tag NO_TAG = PerfMarkImpl.packTag((String)"", (long)Long.MIN_VALUE);
        private static final Link NO_LINK = PerfMarkImpl.packLink((long)Long.MIN_VALUE);
        private static final long INCREMENT = 256L;
        private static final String START_ENABLED_PROPERTY = "io.perfmark.PerfMark.startEnabled";
        private static final AtomicLong linkIdAlloc = new AtomicLong(1L);
        private static final Generator generator;
        private static final Logger logger;
        private static long actualGeneration;

        public PerfMarkImpl(Tag key) {
            super(key);
        }

        protected synchronized void setEnabled(boolean value) {
            PerfMarkImpl.logEnabledChange(value, PerfMarkImpl.setEnabledQuiet(value));
        }

        private static synchronized void logEnabledChange(boolean value, boolean success) {
            if (success && logger.isLoggable(Level.FINE)) {
                logger.fine((value ? "Enabling" : "Disabling") + " PerfMark recorder");
            }
        }

        private static synchronized boolean setEnabledQuiet(boolean value) {
            if (PerfMarkImpl.isEnabled(actualGeneration) == value) {
                return false;
            }
            if (actualGeneration == -512L) {
                return false;
            }
            generator.setGeneration(actualGeneration += 256L);
            return true;
        }

        protected void startTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        protected void startTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName);
        }

        public static void startTask(String taskName, Tag tag, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName, marker, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        public static void startTask(String taskName, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.startAnyways(gen, taskName, marker);
        }

        protected void stopTask(String taskName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        protected void stopTask(String taskName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName);
        }

        public static void stopTask(String taskName, Tag tag, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName, marker, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        public static void stopTask(String taskName, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.stopAnyways(gen, taskName, marker);
        }

        protected void event(String eventName, Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        protected void event(String eventName) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName);
        }

        public static void event(String eventName, Tag tag, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName, marker, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        public static void event(String eventName, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.eventAnyways(gen, eventName, marker);
        }

        protected void attachTag(Tag tag) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.attachTagAnyways(gen, PerfMarkImpl.unpackTagName((Tag)tag), PerfMarkImpl.unpackTagId((Tag)tag));
        }

        protected Tag createTag(@Nullable String tagName, long tagId) {
            if (!PerfMarkImpl.isEnabled(PerfMarkImpl.getGen())) {
                return NO_TAG;
            }
            return PerfMarkImpl.packTag((String)tagName, (long)tagId);
        }

        protected Link linkOut() {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return NO_LINK;
            }
            long linkId = linkIdAlloc.getAndIncrement();
            Storage.linkAnyways(gen, linkId);
            return PerfMarkImpl.packLink((long)linkId);
        }

        public static Link linkOut(Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return NO_LINK;
            }
            long linkId = linkIdAlloc.getAndIncrement();
            Storage.linkAnyways(gen, linkId, marker);
            return PerfMarkImpl.packLink((long)linkId);
        }

        protected void linkIn(Link link) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.linkAnyways(gen, -PerfMarkImpl.unpackLinkId((Link)link));
        }

        public static void linkIn(Link link, Marker marker) {
            long gen = PerfMarkImpl.getGen();
            if (!PerfMarkImpl.isEnabled(gen)) {
                return;
            }
            Storage.linkAnyways(gen, -PerfMarkImpl.unpackLinkId((Link)link), marker);
        }

        private static long getGen() {
            return generator.getGeneration();
        }

        private static boolean isEnabled(long gen) {
            return (gen >>> 8 & 1L) != 0L;
        }

        static {
            ArrayList<Generator> generators = new ArrayList<Generator>();
            ArrayList<ClassNotFoundException> fines = new ArrayList<ClassNotFoundException>();
            ArrayList<Throwable> warnings = new ArrayList<Throwable>();
            Class<?> clz = null;
            try {
                clz = Class.forName("io.perfmark.java7.SecretMethodHandleGenerator$MethodHandleGenerator");
            }
            catch (ClassNotFoundException e) {
                fines.add(e);
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            if (clz != null) {
                try {
                    generators.add(clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    warnings.add(t);
                }
                clz = null;
            }
            try {
                clz = Class.forName("io.perfmark.java9.SecretVarHandleGenerator$VarHandleGenerator");
            }
            catch (ClassNotFoundException e) {
                fines.add(e);
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            if (clz != null) {
                try {
                    generators.add(clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    warnings.add(t);
                }
                clz = null;
            }
            try {
                clz = Class.forName("io.perfmark.java6.SecretVolatileGenerator$VolatileGenerator");
            }
            catch (ClassNotFoundException e) {
                fines.add(e);
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            if (clz != null) {
                try {
                    generators.add(clz.asSubclass(Generator.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    warnings.add(t);
                }
                clz = null;
            }
            generator = !generators.isEmpty() ? (Generator)generators.get(0) : new NoopGenerator();
            boolean startEnabled = false;
            try {
                startEnabled = Boolean.parseBoolean(System.getProperty(START_ENABLED_PROPERTY, "false"));
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            boolean success = PerfMarkImpl.setEnabledQuiet(startEnabled);
            logger = Logger.getLogger(PerfMarkImpl.class.getName());
            logger.log(Level.FINE, "Using {0}", new Object[]{generator.getClass().getName()});
            for (Throwable throwable : warnings) {
                logger.log(Level.WARNING, "Error loading MarkHolderProvider", throwable);
            }
            for (Throwable throwable : fines) {
                logger.log(Level.FINE, "Error loading MarkHolderProvider", throwable);
            }
            PerfMarkImpl.logEnabledChange(startEnabled, success);
        }
    }
}

