/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.Generator;
import io.perfmark.impl.LocalMarkHolder;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkHolderProvider;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.MostlyThreadLocalMarkHolder;
import io.perfmark.impl.NoopMarkHolderProvider;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class Storage {
    static final AtomicLong markHolderIdAllocator;
    static final ConcurrentMap<Reference<Thread>, MarkHolderHandle> allMarkHolders;
    private static final LocalMarkHolder localMarkHolder;
    private static final MarkHolderProvider markHolderProvider;
    private static final ReferenceQueue<Thread> threadReferenceQueue;
    private static volatile long lastGlobalIndexClear;

    public static long getInitNanoTime() {
        return Generator.INIT_NANO_TIME;
    }

    public static List<MarkList> read() {
        long lastReset = lastGlobalIndexClear;
        Storage.drainThreadQueue();
        ArrayList<MarkList> markLists = new ArrayList<MarkList>(allMarkHolders.size());
        Iterator it = allMarkHolders.values().iterator();
        while (it.hasNext()) {
            MarkHolder markHolder;
            MarkHolderHandle handle = (MarkHolderHandle)it.next();
            Thread writer = (Thread)handle.threadRef().get();
            if (writer == null) {
                handle.softenMarkHolderReference();
            }
            if ((markHolder = handle.markHolder()) == null) {
                it.remove();
                handle.clearSoftReference();
                continue;
            }
            String threadName = handle.getAndUpdateThreadName();
            long threadId = handle.getAndUpdateThreadId();
            boolean concurrentWrites = Thread.currentThread() != writer && writer != null;
            markLists.add(MarkList.newBuilder().setMarks(markHolder.read(concurrentWrites)).setThreadName(threadName).setThreadId(threadId).setMarkListId(handle.markHolderId).build());
        }
        return Collections.unmodifiableList(markLists);
    }

    static void startAnyway(long gen, String taskName, @Nullable String tagName, long tagId) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.start(gen, taskName, tagName, tagId, System.nanoTime());
        localMarkHolder.release(mh);
    }

    static void startAnyway(long gen, String taskName) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.start(gen, taskName, System.nanoTime());
        localMarkHolder.release(mh);
    }

    static void startAnyway(long gen, String taskName, String subTaskName) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.start(gen, taskName, subTaskName, System.nanoTime());
        localMarkHolder.release(mh);
    }

    static void stopAnyway(long gen) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.stop(gen, nanoTime);
        localMarkHolder.release(mh);
    }

    static void stopAnyway(long gen, String taskName, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.stop(gen, taskName, tagName, tagId, nanoTime);
        localMarkHolder.release(mh);
    }

    static void stopAnyway(long gen, String taskName) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.stop(gen, taskName, nanoTime);
        localMarkHolder.release(mh);
    }

    static void stopAnyway(long gen, String taskName, String subTaskName) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.stop(gen, taskName, subTaskName, nanoTime);
        localMarkHolder.release(mh);
    }

    static void eventAnyway(long gen, String eventName, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.event(gen, eventName, tagName, tagId, nanoTime);
        localMarkHolder.release(mh);
    }

    static void eventAnyway(long gen, String eventName) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.event(gen, eventName, nanoTime);
        localMarkHolder.release(mh);
    }

    static void eventAnyway(long gen, String eventName, String subEventName) {
        long nanoTime = System.nanoTime();
        MarkHolder mh = localMarkHolder.acquire();
        mh.event(gen, eventName, subEventName, nanoTime);
        localMarkHolder.release(mh);
    }

    static void linkAnyway(long gen, long linkId) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.link(gen, linkId);
        localMarkHolder.release(mh);
    }

    static void attachTagAnyway(long gen, @Nullable String tagName, long tagId) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.attachTag(gen, tagName, tagId);
        localMarkHolder.release(mh);
    }

    static void attachKeyedTagAnyway(long gen, @Nullable String tagName, String tagValue) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.attachKeyedTag(gen, tagName, tagValue);
        localMarkHolder.release(mh);
    }

    static void attachKeyedTagAnyway(long gen, @Nullable String tagName, long tagValue) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.attachKeyedTag(gen, tagName, tagValue);
        localMarkHolder.release(mh);
    }

    static void attachKeyedTagAnyway(long gen, @Nullable String tagName, long tagValue0, long tagValue1) {
        MarkHolder mh = localMarkHolder.acquire();
        mh.attachKeyedTag(gen, tagName, tagValue0, tagValue1);
        localMarkHolder.release(mh);
    }

    public static void clearLocalStorage() {
        Iterator it = allMarkHolders.values().iterator();
        while (it.hasNext()) {
            MarkHolderHandle handle = (MarkHolderHandle)it.next();
            if (handle.threadRef.get() != Thread.currentThread()) continue;
            it.remove();
            handle.threadRef.clearInternal();
            handle.softenMarkHolderReference();
            handle.clearSoftReference();
        }
        localMarkHolder.clear();
    }

    public static void clearGlobalIndex() {
        lastGlobalIndexClear = System.nanoTime() - 1L;
        Iterator it = allMarkHolders.values().iterator();
        while (it.hasNext()) {
            MarkHolderHandle handle = (MarkHolderHandle)it.next();
            handle.softenMarkHolderReference();
            Thread writer = (Thread)handle.threadRef().get();
            if (writer != null) continue;
            it.remove();
            handle.clearSoftReference();
        }
    }

    private static void drainThreadQueue() {
        Reference<Thread> ref;
        while ((ref = threadReferenceQueue.poll()) != null) {
            MarkHolderHandle handle = (MarkHolderHandle)allMarkHolders.get(ref);
            if (handle == null) continue;
            handle.softenMarkHolderReference();
            if (handle.markHolder() != null) continue;
            allMarkHolders.remove(ref);
            handle.clearSoftReference();
        }
        return;
    }

    @Nullable
    public static MarkList readForTest() {
        List<MarkList> lists = Storage.read();
        for (MarkList list : lists) {
            if (list.getThreadId() != Thread.currentThread().getId()) continue;
            return list;
        }
        return null;
    }

    public static MarkHolderAndHandle allocateMarkHolder() {
        Storage.drainThreadQueue();
        long markHolderId = markHolderIdAllocator.getAndIncrement();
        MarkHolder holder = markHolderProvider.create(markHolderId);
        MarkHolderHandle handle = new MarkHolderHandle(Thread.currentThread(), holder, markHolderId);
        allMarkHolders.put(handle.threadRef, handle);
        return new MarkHolderAndHandle(holder, handle);
    }

    private Storage() {
    }

    static {
        Class<?> clz;
        markHolderIdAllocator = new AtomicLong(1L);
        allMarkHolders = new ConcurrentHashMap<Reference<Thread>, MarkHolderHandle>();
        localMarkHolder = new MostlyThreadLocalMarkHolder();
        threadReferenceQueue = new ReferenceQueue();
        lastGlobalIndexClear = Generator.INIT_NANO_TIME - 1L;
        MarkHolderProvider provider = null;
        Throwable[] problems = new Throwable[3];
        try {
            String markHolderOverride = System.getProperty("io.perfmark.PerfMark.markHolderProvider");
            if (markHolderOverride != null && !markHolderOverride.isEmpty()) {
                Class<?> clz2 = Class.forName(markHolderOverride);
                provider = clz2.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Throwable t) {
            problems[0] = t;
        }
        if (provider == null) {
            try {
                clz = Class.forName("io.perfmark.java9.SecretVarHandleMarkHolderProvider$VarHandleMarkHolderProvider");
                provider = clz.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                problems[1] = t;
            }
        }
        if (provider == null) {
            try {
                clz = Class.forName("io.perfmark.java6.SecretSynchronizedMarkHolderProvider$SynchronizedMarkHolderProvider");
                provider = clz.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                problems[2] = t;
            }
        }
        markHolderProvider = provider == null ? new NoopMarkHolderProvider() : provider;
        try {
            if (Boolean.getBoolean("io.perfmark.PerfMark.debug")) {
                Class<?> logClass = Class.forName("java.util.logging.Logger");
                Object logger = logClass.getMethod("getLogger", String.class).invoke(null, Storage.class.getName());
                Class<?> levelClass = Class.forName("java.util.logging.Level");
                Object level = levelClass.getField("FINE").get(null);
                Method logProblemMethod = logClass.getMethod("log", levelClass, String.class, Throwable.class);
                for (Throwable problem : problems) {
                    if (problem == null) continue;
                    logProblemMethod.invoke(logger, level, "Error loading MarkHolderProvider", problem);
                }
                Method logSuccessMethod = logClass.getMethod("log", levelClass, String.class, Object[].class);
                logSuccessMethod.invoke(logger, level, "Using {0}", new Object[]{markHolderProvider.getClass().getName()});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class UnmodifiableWeakReference<T>
    extends WeakReference<T> {
        UnmodifiableWeakReference(T referent, ReferenceQueue<T> q) {
            super(referent, q);
        }

        @Override
        @Deprecated
        public void clear() {
        }

        @Override
        @Deprecated
        public boolean enqueue() {
            return false;
        }

        void clearInternal() {
            super.clear();
        }
    }

    public static final class MarkHolderAndHandle {
        private final MarkHolder markHolder;
        private final MarkHolderHandle handle;

        MarkHolderAndHandle(MarkHolder markHolder, MarkHolderHandle handle) {
            this.markHolder = markHolder;
            this.handle = handle;
            MarkHolder tmp = handle.markHolder();
            if (markHolder != tmp && tmp != null) {
                throw new IllegalArgumentException("Holder Handle mismatch");
            }
        }

        public MarkHolder markHolder() {
            return this.markHolder;
        }

        public MarkHolderHandle handle() {
            return this.handle;
        }
    }

    public static final class MarkHolderHandle {
        private static final SoftReference<MarkHolder> EMPTY = new SoftReference<Object>(null);
        private final UnmodifiableWeakReference<Thread> threadRef;
        private final AtomicReference<MarkHolder> markHolderRef;
        private volatile SoftReference<MarkHolder> softMarkHolderRef;
        private volatile String threadName;
        private volatile long threadId;
        private final long markHolderId;

        MarkHolderHandle(Thread thread, MarkHolder markHolder, long markHolderId) {
            this.threadRef = new UnmodifiableWeakReference<Thread>(thread, (ReferenceQueue<Thread>)threadReferenceQueue);
            this.markHolderRef = new AtomicReference<MarkHolder>(markHolder);
            this.threadName = thread.getName();
            this.threadId = thread.getId();
            this.markHolderId = markHolderId;
        }

        public MarkHolder markHolder() {
            MarkHolder markHolder = this.markHolderRef.get();
            if (markHolder == null) {
                markHolder = this.softMarkHolderRef.get();
                assert (markHolder != null || this.threadRef.get() == null);
            }
            return markHolder;
        }

        public WeakReference<? extends Thread> threadRef() {
            return this.threadRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void softenMarkHolderReference() {
            AtomicReference<MarkHolder> atomicReference = this.markHolderRef;
            synchronized (atomicReference) {
                MarkHolder markHolder = this.markHolderRef.get();
                if (markHolder != null) {
                    this.softMarkHolderRef = new SoftReference<MarkHolder>(markHolder);
                    this.markHolderRef.set(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearSoftReference() {
            Thread thread = (Thread)this.threadRef.get();
            if (thread != null) {
                throw new IllegalStateException("Thread still alive " + thread);
            }
            AtomicReference<MarkHolder> atomicReference = this.markHolderRef;
            synchronized (atomicReference) {
                MarkHolder markHolder = this.markHolderRef.get();
                if (markHolder != null) {
                    throw new IllegalStateException("Handle not yet softened");
                }
                this.softMarkHolderRef.clear();
                this.softMarkHolderRef = EMPTY;
                this.threadName = null;
                this.threadId = -255L;
            }
        }

        String getAndUpdateThreadName() {
            String name;
            Thread t = (Thread)this.threadRef.get();
            if (t != null) {
                this.threadName = name = t.getName();
            } else {
                name = this.threadName;
            }
            return name;
        }

        long getAndUpdateThreadId() {
            long id;
            Thread t = (Thread)this.threadRef.get();
            if (t != null) {
                this.threadId = id = t.getId();
            } else {
                id = this.threadId;
            }
            return id;
        }
    }
}

