/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.transformers.java;

import io.polygenesis.abstraction.data.DataPurpose;
import io.polygenesis.abstraction.thing.FunctionProvider;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.DataTypeTransformer;
import io.polygenesis.core.Nameable;
import io.polygenesis.generators.java.shared.transformer.ClassTransformer;
import io.polygenesis.generators.java.shared.transformer.MethodTransformer;
import io.polygenesis.representations.code.AbstractDataRepresentation;
import io.polygenesis.representations.code.ClassRepresentation;
import io.polygenesis.representations.code.ConstructorRepresentation;
import io.polygenesis.representations.code.FieldRepresentation;
import io.polygenesis.representations.code.MethodRepresentation;
import io.polygenesis.representations.code.MethodRepresentationType;
import io.polygenesis.representations.code.ParameterRepresentation;
import io.polygenesis.transformers.java.AbstractTransformer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractClassTransformer<S extends Nameable, F extends FunctionProvider>
extends AbstractTransformer
implements ClassTransformer<S> {
    private static final String INSTANTIATES_A_NEW_S = "Instantiates a new %s.";
    protected final MethodTransformer<F> methodTransformer;

    public AbstractClassTransformer(DataTypeTransformer dataTypeTransformer, MethodTransformer<F> methodTransformer) {
        super(dataTypeTransformer);
        this.methodTransformer = methodTransformer;
    }

    public ClassRepresentation create(S source, Object ... args) {
        return new ClassRepresentation(this.packageName(source, args), this.imports(source, args), this.annotations(source, args), this.description(source, args), this.modifiers(source, args), this.simpleObjectName(source, args), this.fullObjectName(source, args), this.staticFieldRepresentations(source, args), this.stateFieldRepresentations(source, args), this.dependencyFieldRepresentations(source, args), this.constructorRepresentations(source, args), this.methodRepresentations(source, args));
    }

    public Set<FieldRepresentation> staticFieldRepresentations(S source, Object ... args) {
        return new LinkedHashSet<FieldRepresentation>();
    }

    public Set<FieldRepresentation> stateFieldRepresentations(S source, Object ... args) {
        return new LinkedHashSet<FieldRepresentation>();
    }

    public Set<FieldRepresentation> dependencyFieldRepresentations(S source, Object ... args) {
        return new LinkedHashSet<FieldRepresentation>();
    }

    public Set<ConstructorRepresentation> constructorRepresentations(S source, Object ... args) {
        return new LinkedHashSet<ConstructorRepresentation>();
    }

    public Set<MethodRepresentation> methodRepresentations(S source, Object ... args) {
        return new LinkedHashSet<MethodRepresentation>();
    }

    public String packageName(S source, Object ... args) {
        return "";
    }

    public Set<String> imports(S source, Object ... args) {
        return new LinkedHashSet<String>();
    }

    public Set<String> annotations(S source, Object ... args) {
        return new LinkedHashSet<String>();
    }

    public String description(S source, Object ... args) {
        return String.format("The %s type.", TextConverter.toUpperCamelSpaces((String)source.getObjectName().getText()));
    }

    public String modifiers(S source, Object ... args) {
        return this.dataTypeTransformer.getModifierPublic();
    }

    public String simpleObjectName(S source, Object ... args) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextConverter.toUpperCamel((String)source.getObjectName().getText()));
        return stringBuilder.toString();
    }

    public String fullObjectName(S source, Object ... args) {
        return this.simpleObjectName(source, new Object[0]);
    }

    protected ConstructorRepresentation createEmptyConstructorWithImplementation(String dataType, Set<String> annotations, String modifiers, String implementation) {
        String description = String.format(INSTANTIATES_A_NEW_S, TextConverter.toUpperCamelSpaces((String)dataType));
        return new ConstructorRepresentation(annotations, description, modifiers, new LinkedHashSet(), implementation);
    }

    protected ConstructorRepresentation createConstructorWithImplementation(String dataType, Set<ParameterRepresentation> parameterRepresentations, String implementation) {
        String description = String.format(INSTANTIATES_A_NEW_S, TextConverter.toUpperCamelSpaces((String)dataType));
        return new ConstructorRepresentation(new LinkedHashSet(), description, this.dataTypeTransformer.getModifierPublic(), parameterRepresentations, implementation);
    }

    protected ConstructorRepresentation createConstructorWithSetters(String dataType, Set<ParameterRepresentation> parameterRepresentations) {
        String description = String.format(INSTANTIATES_A_NEW_S, TextConverter.toUpperCamelSpaces((String)dataType));
        return new ConstructorRepresentation(new LinkedHashSet(), description, this.dataTypeTransformer.getModifierPublic(), parameterRepresentations, this.constructorImplementationWithSetters(parameterRepresentations));
    }

    protected ConstructorRepresentation createConstructorWithDirectAssignment(String dataType, Set<ParameterRepresentation> parameterRepresentations) {
        String description = String.format(INSTANTIATES_A_NEW_S, TextConverter.toUpperCamelSpaces((String)dataType));
        return new ConstructorRepresentation(new LinkedHashSet(), description, this.dataTypeTransformer.getModifierPublic(), parameterRepresentations, this.constructorImplementationWithDirectAssignment(parameterRepresentations));
    }

    protected ConstructorRepresentation createNoArgsConstructorForPersistence(String modifier) {
        String description = "No-args constructor for reflections-based frameworks.";
        return new ConstructorRepresentation(new LinkedHashSet(), description, modifier, new LinkedHashSet(), "\t\tsuper();");
    }

    protected ConstructorRepresentation createConstructorWithSettersFromFieldRepresentations(String dataType, Set<FieldRepresentation> fieldRepresentations) {
        return this.createConstructorWithSetters(dataType, this.convertFieldRepresentationsToParameterRepresentations(fieldRepresentations));
    }

    protected ConstructorRepresentation createConstructorWithDirectAssignmentFromFieldRepresentations(String dataType, Set<FieldRepresentation> fieldRepresentations) {
        return this.createConstructorWithDirectAssignment(dataType, this.convertFieldRepresentationsToParameterRepresentations(fieldRepresentations));
    }

    protected Set<MethodRepresentation> methodRepresentationsForGettersAndSetters(Set<FieldRepresentation> fieldRepresentations) {
        LinkedHashSet<MethodRepresentation> methodRepresentations = new LinkedHashSet<MethodRepresentation>();
        if (fieldRepresentations.isEmpty()) {
            return methodRepresentations;
        }
        fieldRepresentations.stream().limit((long)fieldRepresentations.size() - 1L).forEach(fieldRepresentation -> {
            methodRepresentations.add(this.createGetterMethod((FieldRepresentation)fieldRepresentation, (Set<String>)new LinkedHashSet<String>()));
            methodRepresentations.add(this.createSetterMethod((FieldRepresentation)fieldRepresentation, (Set<String>)new LinkedHashSet<String>()));
        });
        FieldRepresentation fieldRepresentationLast = (FieldRepresentation)fieldRepresentations.stream().skip((long)fieldRepresentations.size() - 1L).findFirst().orElseThrow(IllegalArgumentException::new);
        methodRepresentations.add(this.createGetterMethod(fieldRepresentationLast, new LinkedHashSet<String>()));
        methodRepresentations.add(this.createSetterMethod(fieldRepresentationLast, new LinkedHashSet<String>(Arrays.asList("@SuppressWarnings(\"CPD-END\")"))));
        return methodRepresentations;
    }

    protected Set<MethodRepresentation> methodRepresentationsForGettersAndGuards(Set<FieldRepresentation> fieldRepresentations) {
        LinkedHashSet<MethodRepresentation> methodRepresentations = new LinkedHashSet<MethodRepresentation>();
        fieldRepresentations.forEach(fieldRepresentation -> {
            methodRepresentations.add(this.createGetterMethod((FieldRepresentation)fieldRepresentation, (Set<String>)new LinkedHashSet<String>()));
            methodRepresentations.add(this.createGuardMethod((FieldRepresentation)fieldRepresentation, (Set<String>)new LinkedHashSet<String>()));
        });
        return methodRepresentations;
    }

    protected Set<MethodRepresentation> methodRepresentationsForGetters(Set<FieldRepresentation> fieldRepresentations) {
        LinkedHashSet<MethodRepresentation> methodRepresentations = new LinkedHashSet<MethodRepresentation>();
        fieldRepresentations.forEach(fieldRepresentation -> methodRepresentations.add(this.createGetterMethod((FieldRepresentation)fieldRepresentation, (Set<String>)new LinkedHashSet<String>())));
        return methodRepresentations;
    }

    protected MethodRepresentation createGetterMethod(FieldRepresentation fieldRepresentation, Set<String> annotations) {
        return new MethodRepresentation(MethodRepresentationType.GETTER, new LinkedHashSet(), annotations, String.format("Gets the %s.", TextConverter.toUpperCamelSpaces((String)fieldRepresentation.getVariableName())), this.dataTypeTransformer.getModifierPublic(), String.format("get%s", TextConverter.toUpperCamel((String)fieldRepresentation.getVariableName())), new LinkedHashSet(), fieldRepresentation.getDataType(), String.format("\t\treturn this.%s;", fieldRepresentation.getVariableName()), new LinkedHashSet());
    }

    protected MethodRepresentation createGuardMethod(FieldRepresentation fieldRepresentation, Set<String> annotations) {
        return this.createSetterOrGuardMethod(fieldRepresentation, MethodRepresentationType.GUARD, annotations);
    }

    protected MethodRepresentation createSetterMethod(FieldRepresentation fieldRepresentation, Set<String> annotations) {
        return this.createSetterOrGuardMethod(fieldRepresentation, MethodRepresentationType.SETTER, annotations);
    }

    protected String makeCanonicalObjectName(PackageName packageName, String dataType) {
        return packageName.getText() + "." + TextConverter.toUpperCamel((String)dataType);
    }

    private MethodRepresentation createSetterOrGuardMethod(FieldRepresentation fieldRepresentation, MethodRepresentationType methodRepresentationType, Set<String> annotations) {
        String modifiers;
        switch (methodRepresentationType) {
            case GUARD: {
                modifiers = "private";
                break;
            }
            case SETTER: {
                modifiers = this.dataTypeTransformer.getModifierPublic();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (methodRepresentationType.equals((Object)MethodRepresentationType.GUARD)) {
            stringBuilder.append("\t\t");
            stringBuilder.append("Assertion.isNotNull(");
            stringBuilder.append(fieldRepresentation.getVariableName());
            stringBuilder.append(",");
            stringBuilder.append(" \"");
            stringBuilder.append(TextConverter.toUpperCamelSpaces((String)fieldRepresentation.getVariableName()));
            stringBuilder.append(" is required\"");
            stringBuilder.append(");");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\t\t");
        stringBuilder.append("this.");
        stringBuilder.append(fieldRepresentation.getVariableName());
        stringBuilder.append(" = ");
        stringBuilder.append(fieldRepresentation.getVariableName());
        stringBuilder.append(";");
        LinkedHashSet<ParameterRepresentation> parameterRepresentations = new LinkedHashSet<ParameterRepresentation>(Arrays.asList(new ParameterRepresentation(fieldRepresentation.getDataType(), fieldRepresentation.getVariableName())));
        return new MethodRepresentation(methodRepresentationType, new LinkedHashSet(), annotations, String.format("Sets the %s.", TextConverter.toUpperCamelSpaces((String)fieldRepresentation.getVariableName())), modifiers, String.format("set%s", TextConverter.toUpperCamel((String)fieldRepresentation.getVariableName())), parameterRepresentations, "void", stringBuilder.toString(), new LinkedHashSet());
    }

    protected Set<ParameterRepresentation> convertFieldRepresentationsToParameterRepresentations(Set<FieldRepresentation> fieldRepresentations) {
        return fieldRepresentations.stream().map(fieldRepresentation -> new ParameterRepresentation(fieldRepresentation.getDataType(), fieldRepresentation.getVariableName(), fieldRepresentation.getAnnotations(), fieldRepresentation.getDataPurpose())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String constructorImplementationWithSetters(Set<ParameterRepresentation> parameterRepresentations) {
        StringBuilder stringBuilder = new StringBuilder();
        parameterRepresentations.forEach(parameterRepresentation -> {
            if (parameterRepresentation.getDataPurpose().equals((Object)DataPurpose.thingIdentity())) {
                stringBuilder.append("\t\t");
                stringBuilder.append("super(");
                stringBuilder.append(TextConverter.toLowerCamel((String)parameterRepresentation.getVariableName()));
                Optional<ParameterRepresentation> optionalTenantIdentity = parameterRepresentations.stream().filter(parameterRepresentation1 -> parameterRepresentation1.getDataPurpose().equals((Object)DataPurpose.tenantIdentity())).findFirst();
                if (optionalTenantIdentity.isPresent()) {
                    stringBuilder.append(", ");
                    stringBuilder.append(TextConverter.toLowerCamel((String)optionalTenantIdentity.orElseThrow(IllegalArgumentException::new).getVariableName()));
                }
                stringBuilder.append(");");
                if (parameterRepresentations.size() > 1) {
                    stringBuilder.append("\n");
                }
            }
            if (!parameterRepresentation.getDataPurpose().equals((Object)DataPurpose.thingIdentity()) && !parameterRepresentation.getDataPurpose().equals((Object)DataPurpose.tenantIdentity())) {
                stringBuilder.append("\t\t");
                stringBuilder.append("set");
                stringBuilder.append(TextConverter.toUpperCamel((String)parameterRepresentation.getVariableName()));
                stringBuilder.append("(");
                stringBuilder.append(TextConverter.toLowerCamel((String)parameterRepresentation.getVariableName()));
                stringBuilder.append(");");
                stringBuilder.append("\n");
            }
        });
        String impl = stringBuilder.toString();
        if (impl.endsWith("\n")) {
            impl = impl.substring(0, impl.length() - 1);
        }
        return impl;
    }

    private String constructorImplementationWithDirectAssignment(Set<ParameterRepresentation> parameterRepresentations) {
        StringBuilder stringBuilder = new StringBuilder();
        String callSuperWithParameters = this.callSuperWithParameters(parameterRepresentations);
        if (!callSuperWithParameters.equals("")) {
            stringBuilder.append(String.format("\t\tsuper(%s);%n", callSuperWithParameters));
        } else if (parameterRepresentations.isEmpty()) {
            return "\t\tsuper();";
        }
        parameterRepresentations.stream().filter(parameterRepresentation -> !parameterRepresentation.getDataPurpose().equals((Object)DataPurpose.superclassParameter())).forEach(parameterRepresentation -> {
            if (!parameterRepresentation.getDataPurpose().equals((Object)DataPurpose.thingIdentity())) {
                stringBuilder.append("\t\t");
                stringBuilder.append("this.");
                stringBuilder.append(TextConverter.toLowerCamel((String)parameterRepresentation.getVariableName()));
                stringBuilder.append(" = ");
                stringBuilder.append(TextConverter.toLowerCamel((String)parameterRepresentation.getVariableName()));
                stringBuilder.append(";");
                stringBuilder.append("\n");
            }
        });
        String impl = stringBuilder.toString();
        if (impl.endsWith("\n")) {
            impl = impl.substring(0, impl.length() - 1);
        }
        return impl;
    }

    private String callSuperWithParameters(Set<ParameterRepresentation> parameterRepresentations) {
        return parameterRepresentations.stream().filter(parameterRepresentation -> parameterRepresentation.getDataPurpose().equals((Object)DataPurpose.superclassParameter())).map(AbstractDataRepresentation::getVariableName).collect(Collectors.joining(", "));
    }
}

