/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.transformers.java;

import io.polygenesis.abstraction.thing.FunctionProvider;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.DataTypeTransformer;
import io.polygenesis.core.Nameable;
import io.polygenesis.core.TemplateData;
import io.polygenesis.generators.java.shared.transformer.InterfaceTransformer;
import io.polygenesis.generators.java.shared.transformer.MethodTransformer;
import io.polygenesis.representations.code.InterfaceRepresentation;
import io.polygenesis.representations.code.MethodRepresentation;
import io.polygenesis.transformers.java.AbstractTransformer;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractInterfaceTransformer<S extends Nameable, F extends FunctionProvider>
extends AbstractTransformer
implements InterfaceTransformer<S> {
    protected static final String MODIFIER_PUBLIC = "public";
    protected final MethodTransformer<F> methodTransformer;

    public AbstractInterfaceTransformer(DataTypeTransformer dataTypeTransformer, MethodTransformer<F> methodTransformer) {
        super(dataTypeTransformer);
        this.methodTransformer = methodTransformer;
    }

    public TemplateData transform(S source, Object ... args) {
        throw new UnsupportedOperationException("Must be implemented");
    }

    public InterfaceRepresentation create(S source, Object ... args) {
        return new InterfaceRepresentation(this.packageName(source, args), this.imports(source, args), this.annotations(source, args), this.description(source, args), this.modifiers(source, args), this.simpleObjectName(source, args), this.fullObjectName(source, args), this.methodRepresentations(source, args));
    }

    public Set<MethodRepresentation> methodRepresentations(S source, Object ... args) {
        return new LinkedHashSet<MethodRepresentation>();
    }

    public String packageName(S source, Object ... args) {
        return "";
    }

    public Set<String> imports(S source, Object ... args) {
        return new LinkedHashSet<String>();
    }

    public Set<String> annotations(S source, Object ... args) {
        return new LinkedHashSet<String>();
    }

    public String description(S source, Object ... args) {
        return String.format("The %s type.", TextConverter.toUpperCamelSpaces((String)source.getObjectName().getText()));
    }

    public String modifiers(S source, Object ... args) {
        return this.dataTypeTransformer.getModifierPublic();
    }

    public String simpleObjectName(S source, Object ... args) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextConverter.toUpperCamel((String)source.getObjectName().getText()));
        return stringBuilder.toString();
    }

    public String fullObjectName(S source, Object ... args) {
        return this.simpleObjectName(source, new Object[0]);
    }

    protected String makeCanonicalObjectName(PackageName packageName, String dataType) {
        return packageName.getText() + "." + TextConverter.toUpperCamel((String)dataType);
    }
}

