/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.transformers.java;

import io.polygenesis.abstraction.data.DataObject;
import io.polygenesis.abstraction.data.PrimitiveType;
import io.polygenesis.abstraction.thing.FunctionProvider;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.PackageName;
import io.polygenesis.core.DataTypeTransformer;
import io.polygenesis.generators.java.shared.transformer.MethodTransformer;
import io.polygenesis.representations.code.AbstractDataRepresentation;
import io.polygenesis.representations.code.MethodRepresentation;
import io.polygenesis.representations.code.MethodRepresentationType;
import io.polygenesis.representations.code.ParameterRepresentation;
import io.polygenesis.transformers.java.AbstractTransformer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class AbstractMethodTransformer<S extends FunctionProvider>
extends AbstractTransformer
implements MethodTransformer<S> {
    protected static final String MODIFIER_PUBLIC = "public";

    public AbstractMethodTransformer(DataTypeTransformer dataTypeTransformer) {
        super(dataTypeTransformer);
    }

    public MethodRepresentation create(S source, Object ... args) {
        return new MethodRepresentation(this.methodType(source, args), this.imports(source, args), this.annotations(source, args), this.description(source, args), this.modifiers(source, args), this.methodName(source, args), this.parameterRepresentations(source, args), this.returnValue(source, args), this.implementation(source, args), this.thrownExceptions(source, args));
    }

    public MethodRepresentationType methodType(S source, Object ... args) {
        return MethodRepresentationType.ANY;
    }

    public Set<String> imports(S source, Object ... args) {
        TreeSet<String> imports = new TreeSet<String>();
        if (source.getFunction().getReturnValue() != null && source.getFunction().getReturnValue().isDataGroup()) {
            DataObject dataObject2 = source.getFunction().getReturnValue().getAsDataObject();
            imports.add(this.makeCanonicalObjectName(dataObject2.getPackageName(), dataObject2.getDataType()));
        }
        Set dataObjects = source.getFunction().getAllArgumentsDataObjects();
        dataObjects.forEach(dataObject -> imports.add(this.makeCanonicalObjectName(dataObject.getPackageName(), dataObject.getDataType())));
        return imports;
    }

    public Set<String> annotations(S source, Object ... args) {
        return new LinkedHashSet<String>();
    }

    public String description(S source, Object ... args) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextConverter.toUpperCamelSpaces((String)source.getFunction().getName().getText()));
        stringBuilder.append(".");
        return stringBuilder.toString();
    }

    public String modifiers(S source, Object ... args) {
        return MODIFIER_PUBLIC;
    }

    public String methodName(S source, Object ... args) {
        return source.getFunction().getName().getText();
    }

    public Set<ParameterRepresentation> parameterRepresentations(S source, Object ... args) {
        LinkedHashSet<ParameterRepresentation> parameterRepresentations = new LinkedHashSet<ParameterRepresentation>();
        source.getFunction().getArguments().getData().forEach(argument -> parameterRepresentations.add(new ParameterRepresentation(this.dataTypeTransformer.convert(argument.getDataType()), argument.getVariableName().getText())));
        return parameterRepresentations;
    }

    public String returnValue(S source, Object ... args) {
        if (source.getFunction().getReturnValue() != null) {
            return this.makeVariableDataType(source.getFunction().getReturnValue());
        }
        return this.dataTypeTransformer.convert(PrimitiveType.VOID.name());
    }

    public String implementation(S source, Object ... args) {
        if (source.getFunction().getReturnValue() == null) {
            return "\t\t// TODO: implementation";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\t// TODO: implementation\n");
        stringBuilder.append("\t\treturn null;");
        return stringBuilder.toString();
    }

    public Set<String> thrownExceptions(S source, Object ... args) {
        return new LinkedHashSet<String>();
    }

    protected String makeCanonicalObjectName(PackageName packageName, String dataType) {
        return packageName.getText() + "." + TextConverter.toUpperCamel((String)dataType);
    }

    protected String getParametersCommaSeparated(Set<ParameterRepresentation> parameterRepresentations) {
        return parameterRepresentations.stream().map(AbstractDataRepresentation::getVariableName).collect(Collectors.joining(", "));
    }
}

