/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.transformers.java;

import io.polygenesis.abstraction.data.Data;
import io.polygenesis.core.DataTypeTransformer;

public class AbstractTransformer {
    protected final DataTypeTransformer dataTypeTransformer;

    public AbstractTransformer(DataTypeTransformer dataTypeTransformer) {
        this.dataTypeTransformer = dataTypeTransformer;
    }

    protected String makeVariableDataType(Data model) {
        if (model.isDataArray()) {
            return String.format("List<%s>", this.dataTypeTransformer.convert(model.getAsDataArray().getArrayElement().getDataType()));
        }
        if (model.isDataMap()) {
            return String.format("Map<%s, %s>", this.dataTypeTransformer.convert(model.getAsDataMap().getKey().getDataType()), this.dataTypeTransformer.convert(model.getAsDataMap().getValue().getDataType()));
        }
        return this.dataTypeTransformer.convert(model.getDataType());
    }

    protected String makeVariableName(Data model) {
        return model.getVariableName().getText();
    }
}

