/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.transformers.web;

import io.polygenesis.abstraction.data.PrimitiveType;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.core.DataTypeTransformer;
import java.util.EnumMap;
import java.util.stream.Stream;

public class HtmlDataTypeTransformer
implements DataTypeTransformer {
    private static final String MODIFIER_PUBLIC = "public";
    private static final String MODIFIER_PROTECTED = "protected";
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_ABSTRACT = "abstract";
    private static final String VOID = "void";
    private static EnumMap<PrimitiveType, String> dataTypeMap;

    public String convert(String dataType) {
        String candidate = TextConverter.toUpperCamel((String)dataType);
        return Stream.of(PrimitiveType.values()).filter(value -> value.name().equalsIgnoreCase(candidate)).findFirst().map(primaryType -> dataTypeMap.get(primaryType)).orElse(candidate);
    }

    public String getModifierPublic() {
        return MODIFIER_PUBLIC;
    }

    public String getModifierProtected() {
        return MODIFIER_PROTECTED;
    }

    public String getModifierPrivate() {
        return MODIFIER_PRIVATE;
    }

    public String getModifierPrivateFinal() {
        return MODIFIER_PRIVATE;
    }

    public String getModifierAbstract() {
        return MODIFIER_ABSTRACT;
    }

    public String getVoid() {
        return VOID;
    }

    public String getArrayOfElements(String elementDataType) {
        throw new UnsupportedOperationException();
    }

    private static void initialize() {
        dataTypeMap = new EnumMap(PrimitiveType.class);
        dataTypeMap.put(PrimitiveType.VOID, VOID);
        dataTypeMap.put(PrimitiveType.STRING, "String");
        dataTypeMap.put(PrimitiveType.INTEGER, "int");
        dataTypeMap.put(PrimitiveType.LONG, "Long");
        dataTypeMap.put(PrimitiveType.BOOLEAN, "Boolean");
        dataTypeMap.put(PrimitiveType.DATE, "LocalDate");
        dataTypeMap.put(PrimitiveType.DATETIME, "LocalDateTime");
        dataTypeMap.put(PrimitiveType.DECIMAL, "BigDecimal");
        dataTypeMap.put(PrimitiveType.UUID, "UUID");
    }

    static {
        HtmlDataTypeTransformer.initialize();
    }
}

