/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.matching;

import com.google.common.collect.MoreCollectors;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Match;
import io.prestosql.matching.Pattern;
import io.prestosql.matching.Property;
import io.prestosql.matching.example.rel.FilterNode;
import io.prestosql.matching.example.rel.JoinNode;
import io.prestosql.matching.example.rel.Patterns;
import io.prestosql.matching.example.rel.ProjectNode;
import io.prestosql.matching.example.rel.RelNode;
import io.prestosql.matching.example.rel.ScanNode;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMatcher {
    @Test
    public void trivialMatchers() {
        this.assertMatch(Pattern.any(), 42);
        this.assertMatch(Pattern.any(), "John Doe");
        this.assertMatch(Pattern.typeOf(Integer.class), 42);
        this.assertMatch(Pattern.typeOf(Number.class), 42);
        this.assertNoMatch(Pattern.typeOf(Integer.class), "John Doe");
        this.assertMatch(Pattern.typeOf(Integer.class).matching(x -> x > 0), 42);
        this.assertNoMatch(Pattern.typeOf(Integer.class).matching(x -> x > 0), -1);
    }

    @Test
    public void matchObject() {
        this.assertMatch(Patterns.project(), new ProjectNode(null));
        this.assertNoMatch(Patterns.project(), new ScanNode("t"));
    }

    @Test
    public void propertyMatchers() {
        Pattern aString = Pattern.typeOf(String.class);
        Property length = Property.property((String)"length", String::length);
        String string = "a";
        this.assertMatch(aString.with(length.equalTo((Object)1)), string);
        this.assertMatch(Patterns.project().with(Patterns.source().matching(Patterns.scan())), new ProjectNode(new ScanNode("T")));
        this.assertMatch(aString.with(length.matching(Pattern.any())), string);
        this.assertMatch(aString.with(length.matching(x -> x > 0)), string);
        this.assertMatch(aString.with(length.matching(x -> x.intValue() > 0)), string);
        this.assertNoMatch(aString.with(length.equalTo((Object)0)), string);
        this.assertNoMatch(Patterns.project().with(Patterns.source().matching(Patterns.scan())), new ProjectNode(new ProjectNode(new ScanNode("T"))));
        this.assertNoMatch(aString.with(length.matching(Pattern.typeOf(Void.class))), string);
        this.assertNoMatch(aString.with(length.matching(x -> x < 1)), string);
        this.assertNoMatch(aString.with(length.matching(x -> x.intValue() < 1)), string);
    }

    @Test
    public void matchNestedProperties() {
        Pattern pattern = Patterns.project().with(Patterns.source().matching(Patterns.scan()));
        this.assertMatch(pattern, new ProjectNode(new ScanNode("t")));
        this.assertNoMatch(pattern, new ScanNode("t"));
        this.assertNoMatch(pattern, new ProjectNode(new ProjectNode(null)));
    }

    @Test
    public void matchAdditionalProperties() {
        String matchedValue = "A little string.";
        Pattern pattern = Pattern.typeOf(String.class).matching(s -> s.startsWith("A")).matching(s -> s.length() > 7);
        this.assertMatch(pattern, matchedValue);
    }

    @Test
    public void optionalProperties() {
        Property onlySource = Property.optionalProperty((String)"onlySource", node -> Optional.of(node.getSources()).filter(sources -> sources.size() == 1).map(sources -> (RelNode)sources.get(0)));
        Pattern relNodeWithExactlyOneSource = Patterns.plan().with(onlySource.matching(Pattern.any()));
        this.assertMatch(relNodeWithExactlyOneSource, new ProjectNode(new ScanNode("t")));
        this.assertNoMatch(relNodeWithExactlyOneSource, new ScanNode("t"));
        this.assertNoMatch(relNodeWithExactlyOneSource, new JoinNode(new ScanNode("t"), new ScanNode("t")));
    }

    @Test
    public void capturingMatchesInATypesafeManner() {
        Capture filter = Capture.newCapture();
        Capture scan = Capture.newCapture();
        Capture name = Capture.newCapture();
        Pattern pattern = Patterns.project().with(Patterns.source().matching(Patterns.filter().capturedAs(filter).with(Patterns.source().matching(Patterns.scan().capturedAs(scan).with(Patterns.tableName().capturedAs(name))))));
        ProjectNode tree = new ProjectNode(new FilterNode(new ScanNode("orders"), null));
        Match match = this.assertMatch(pattern, tree);
        FilterNode capturedFilter = (FilterNode)match.capture(filter);
        Assert.assertEquals((Object)tree.getSource(), (Object)capturedFilter);
        Assert.assertEquals((Object)((FilterNode)tree.getSource()).getSource(), (Object)match.capture(scan));
        Assert.assertEquals((String)"orders", (String)((String)match.capture(name)));
    }

    @Test
    public void noMatch() {
        Capture impossible = Capture.newCapture();
        Pattern pattern = Pattern.typeOf(Void.class).capturedAs(impossible);
        Optional match = (Optional)pattern.match((Object)42).collect(MoreCollectors.toOptional());
        Assert.assertFalse((boolean)match.isPresent());
    }

    @Test
    public void unknownCaptureIsAnError() {
        Pattern pattern = Pattern.any();
        Capture unknownCapture = Capture.newCapture();
        Match match = (Match)pattern.match((Object)42).collect(MoreCollectors.onlyElement());
        Throwable throwable = Assert.expectThrows(NoSuchElementException.class, () -> match.capture(unknownCapture));
        Assert.assertTrue((boolean)throwable.getMessage().contains("unknown Capture"));
    }

    @Test
    public void nullNotMatchedByDefault() {
        this.assertNoMatch(Pattern.any(), null);
        this.assertNoMatch(Pattern.typeOf(Integer.class), null);
    }

    @Test
    public void contextIsPassedToPropertyFunction() {
        Pattern pattern = Pattern.any().with(Property.property((String)"non null", (value, context) -> {
            context.set(true);
            return value != null;
        }).equalTo((Object)true));
        AtomicBoolean wasContextUsed = new AtomicBoolean();
        pattern.match((Object)"object", (Object)wasContextUsed).collect(MoreCollectors.onlyElement());
        Assert.assertEquals((boolean)wasContextUsed.get(), (boolean)true);
    }

    @Test
    public void contextIsPassedToPredicate() {
        Pattern pattern = Pattern.any().matching((value, context) -> {
            context.set(true);
            return value != null;
        });
        AtomicBoolean wasContextUsed = new AtomicBoolean();
        pattern.match((Object)"object", (Object)wasContextUsed).collect(MoreCollectors.onlyElement());
        Assert.assertEquals((boolean)wasContextUsed.get(), (boolean)true);
    }

    private <T> Match assertMatch(Pattern<T> pattern, T object) {
        return (Match)pattern.match(object).collect(MoreCollectors.onlyElement());
    }

    private <T> void assertNoMatch(Pattern<T> pattern, Object expectedNoMatch) {
        Optional match = (Optional)pattern.match(expectedNoMatch).collect(MoreCollectors.toOptional());
        Assert.assertFalse((boolean)match.isPresent());
    }
}

