/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.base.security.FileBasedAccessControl;
import io.prestosql.plugin.base.security.FileBasedAccessControlConfig;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.testing.InterfaceTestUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileBasedAccessControl {
    public static final ConnectorTransactionHandle TRANSACTION_HANDLE = new ConnectorTransactionHandle(){};

    @Test
    public void testSchemaRules() throws IOException {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("admin"), new SchemaTableName("test", "test"));
        accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("bob", "test"));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("test", "test")));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanCreateTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("admin"), new SchemaTableName("secret", "test")));
    }

    @Test
    public void testTableRules() throws IOException {
        ConnectorAccessControl accessControl = this.createAccessControl("table.json");
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), new SchemaTableName("test", "test"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of((Object)"bobcolumn"));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of());
        accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("bobschema", "bobtable"));
        accessControl.checkCanDeleteFromTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("bobschema", "bobtable"));
        accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("joe"), new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of());
        accessControl.checkCanCreateViewWithSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of());
        accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("admin"), new SchemaTableName("bobschema", "bobtable"));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), new SchemaTableName("bobschema", "bobtable")));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanDropTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("bobschema", "bobtable")));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanInsertIntoTable(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), new SchemaTableName("test", "test")));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("admin"), new SchemaTableName("secret", "secret"), (Set)ImmutableSet.of()));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("joe"), new SchemaTableName("secret", "secret"), (Set)ImmutableSet.of()));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("joe"), new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of()));
    }

    @Test
    public void testSessionPropertyRules() throws IOException {
        ConnectorAccessControl accessControl = this.createAccessControl("session_property.json");
        accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("admin"), "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), "safe");
        accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), "unsafe");
        accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), "safe");
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("bob"), "unsafe"));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("alice"), "dangerous"));
        TestFileBasedAccessControl.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(TRANSACTION_HANDLE, TestFileBasedAccessControl.user("charlie"), "safe"));
    }

    @Test
    public void testInvalidRules() {
        Assertions.assertThatThrownBy(() -> this.createAccessControl("invalid.json")).hasMessageContaining("Invalid JSON");
    }

    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(ConnectorAccessControl.class, FileBasedAccessControl.class);
    }

    private static ConnectorIdentity user(String name) {
        return new ConnectorIdentity(name, Optional.empty(), Optional.empty());
    }

    private ConnectorAccessControl createAccessControl(String fileName) throws IOException {
        String path = this.getClass().getClassLoader().getResource(fileName).getPath();
        FileBasedAccessControlConfig config = new FileBasedAccessControlConfig();
        config.setConfigFile(path);
        return new FileBasedAccessControl(config);
    }

    private static void assertDenied(Assert.ThrowingRunnable runnable) {
        Assert.assertThrows(AccessDeniedException.class, (Assert.ThrowingRunnable)runnable);
    }
}

