/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.base.security.FileBasedAccessControlConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestFileBasedAccessControlConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FileBasedAccessControlConfig)ConfigAssertions.recordDefaults(FileBasedAccessControlConfig.class)).setConfigFile(null).setRefreshPeriod(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"security.config-file", (Object)"/test.json").put((Object)"security.refresh-period", (Object)"1s").build();
        FileBasedAccessControlConfig expected = new FileBasedAccessControlConfig().setConfigFile("/test.json").setRefreshPeriod(new Duration(1.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedAccessControlConfig.newInstance((Map<String, String>)ImmutableMap.of((Object)"security.refresh-period", (Object)"1ms"))).isInstanceOf(ConfigurationException.class)).hasMessageContaining("security.config-file: may not be null ");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestFileBasedAccessControlConfig.newInstance((Map<String, String>)ImmutableMap.of((Object)"security.config-file", (Object)"/test.json", (Object)"security.refresh-period", (Object)"1us"))).isInstanceOf(ConfigurationException.class)).hasMessageContaining("Invalid configuration property security.refresh-period");
        TestFileBasedAccessControlConfig.newInstance((Map<String, String>)ImmutableMap.of((Object)"security.config-file", (Object)"/test.json"));
    }

    private static FileBasedAccessControlConfig newInstance(Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        return (FileBasedAccessControlConfig)configurationFactory.build(FileBasedAccessControlConfig.class);
    }
}

