/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.avro;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.DecoderTestColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.avro.AvroRowDecoderFactory;
import io.prestosql.decoder.util.DecoderTestUtil;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAvroDecoder {
    private static final String DATA_SCHEMA = "dataSchema";
    private static final AvroRowDecoderFactory DECODER_FACTORY = new AvroRowDecoderFactory();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final Type VARCHAR_MAP_TYPE = METADATA.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
    private static final Type DOUBLE_MAP_TYPE = METADATA.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)DoubleType.DOUBLE.getTypeSignature()));
    private static final Type REAL_MAP_TYPE = METADATA.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)RealType.REAL.getTypeSignature()));

    private static String getAvroSchema(String name, String dataType) {
        return TestAvroDecoder.getAvroSchema((Map<String, String>)ImmutableMap.of((Object)name, (Object)dataType));
    }

    private static String determineDefaultValue(String dataType) {
        if (dataType.contains("\"array\"")) {
            return ", \"default\": []";
        }
        if (dataType.contains("\"map\"")) {
            return ", \"default\": {}";
        }
        if (dataType.contains("null")) {
            return ", \"default\": null";
        }
        return "";
    }

    private static String getAvroSchema(Map<String, String> fields) {
        String fieldSchema = fields.entrySet().stream().map(entry -> "{\"name\": \"" + (String)entry.getKey() + "\",\"type\": " + (String)entry.getValue() + TestAvroDecoder.determineDefaultValue((String)entry.getValue()) + "}").collect(Collectors.joining(","));
        return "{\"type\" : \"record\",  \"name\" : \"test_schema\",  \"namespace\" : \"io.prestosql.decoder.avro\",  \"fields\" :  [" + fieldSchema + "  ]}";
    }

    private Map<DecoderColumnHandle, FieldValueProvider> buildAndDecodeColumns(Set<DecoderColumnHandle> columns, Map<String, String> fieldSchema, Map<String, Object> fieldValue) {
        String schema = TestAvroDecoder.getAvroSchema(fieldSchema);
        byte[] avroData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(schema), fieldValue);
        return TestAvroDecoder.decodeRow(avroData, columns, (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)schema));
    }

    private Map<DecoderColumnHandle, FieldValueProvider> buildAndDecodeColumn(DecoderTestColumnHandle column, String columnName, String columnType, Object actualValue) {
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumns((Set<DecoderColumnHandle>)ImmutableSet.of((Object)column), (Map<String, String>)ImmutableMap.of((Object)columnName, (Object)columnType), (Map<String, Object>)ImmutableMap.of((Object)columnName, (Object)actualValue));
        Assert.assertEquals((int)decodedRow.size(), (int)1);
        return decodedRow;
    }

    private static Map<DecoderColumnHandle, FieldValueProvider> decodeRow(byte[] avroData, Set<DecoderColumnHandle> columns, Map<String, String> dataParams) {
        RowDecoder rowDecoder = DECODER_FACTORY.create(dataParams, columns);
        return (Map)rowDecoder.decodeRow(avroData, null).orElseThrow(AssertionError::new);
    }

    private static byte[] buildAvroData(Schema schema, String name, Object value) {
        return TestAvroDecoder.buildAvroData(schema, (Map<String, Object>)ImmutableMap.of((Object)name, (Object)value));
    }

    private static byte[] buildAvroData(Schema schema, Map<String, Object> values) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TestAvroDecoder.buildAvroRecord(schema, outputStream, values);
        return outputStream.toByteArray();
    }

    private static GenericData.Record buildAvroRecord(Schema schema, ByteArrayOutputStream outputStream, Map<String, Object> values) {
        GenericData.Record record = new GenericData.Record(schema);
        values.forEach((arg_0, arg_1) -> ((GenericData.Record)record).put(arg_0, arg_1));
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            dataFileWriter.create(schema, (OutputStream)outputStream);
            dataFileWriter.append((Object)record);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert to Avro.", e);
        }
        return record;
    }

    @Test
    public void testStringDecodedAsVarchar() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarcharType.VARCHAR, "string_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "string_field", "\"string\"", "Mon Jul 28 20:38:07 +0000 2014");
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "Mon Jul 28 20:38:07 +0000 2014");
    }

    @Test
    public void testSchemaEvolutionAddingColumn() {
        DecoderTestColumnHandle originalColumn = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "string_field", null, null, false, false, false);
        DecoderTestColumnHandle newlyAddedColumn = new DecoderTestColumnHandle(1, "row1", (Type)VarcharType.VARCHAR, "string_field_added", null, null, false, false, false);
        byte[] originalData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(TestAvroDecoder.getAvroSchema("string_field", "\"string\"")), "string_field", "string_field_value");
        String addedColumnSchema = TestAvroDecoder.getAvroSchema((Map<String, String>)ImmutableMap.of((Object)"string_field", (Object)"\"string\"", (Object)"string_field_added", (Object)"[\"null\", \"string\"]"));
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = TestAvroDecoder.decodeRow(originalData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)originalColumn, (Object)newlyAddedColumn), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)addedColumnSchema));
        Assert.assertEquals((int)decodedRow.size(), (int)2);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)originalColumn, "string_field_value");
        DecoderTestUtil.checkIsNull(decodedRow, newlyAddedColumn);
    }

    @Test
    public void testSchemaEvolutionRenamingColumn() {
        byte[] originalData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(TestAvroDecoder.getAvroSchema("string_field", "\"string\"")), "string_field", "string_field_value");
        DecoderTestColumnHandle renamedColumn = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "string_field_renamed", null, null, false, false, false);
        String renamedColumnSchema = TestAvroDecoder.getAvroSchema("string_field_renamed", "[\"null\", \"string\"]");
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)renamedColumn), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)renamedColumnSchema));
        Assert.assertEquals((int)decodedEvolvedRow.size(), (int)1);
        DecoderTestUtil.checkIsNull(decodedEvolvedRow, renamedColumn);
    }

    @Test
    public void testSchemaEvolutionRemovingColumn() {
        byte[] originalData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(TestAvroDecoder.getAvroSchema((Map<String, String>)ImmutableMap.of((Object)"string_field", (Object)"\"string\"", (Object)"string_field_to_be_removed", (Object)"[\"null\", \"string\"]"))), (Map<String, Object>)ImmutableMap.of((Object)"string_field", (Object)"string_field_value", (Object)"string_field_to_be_removed", (Object)"removed_field_value"));
        DecoderTestColumnHandle evolvedColumn = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "string_field", null, null, false, false, false);
        String removedColumnSchema = TestAvroDecoder.getAvroSchema("string_field", "\"string\"");
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)evolvedColumn), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)removedColumnSchema));
        Assert.assertEquals((int)decodedEvolvedRow.size(), (int)1);
        DecoderTestUtil.checkValue(decodedEvolvedRow, (DecoderColumnHandle)evolvedColumn, "string_field_value");
    }

    @Test
    public void testSchemaEvolutionIntToLong() {
        byte[] originalIntData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(TestAvroDecoder.getAvroSchema("int_to_long_field", "\"int\"")), "int_to_long_field", 100);
        DecoderTestColumnHandle longColumnReadingIntData = new DecoderTestColumnHandle(0, "row0", (Type)BigintType.BIGINT, "int_to_long_field", null, null, false, false, false);
        String changedTypeSchema = TestAvroDecoder.getAvroSchema("int_to_long_field", "\"long\"");
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalIntData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)longColumnReadingIntData), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)changedTypeSchema));
        Assert.assertEquals((int)decodedEvolvedRow.size(), (int)1);
        DecoderTestUtil.checkValue(decodedEvolvedRow, (DecoderColumnHandle)longColumnReadingIntData, 100L);
    }

    @Test
    public void testSchemaEvolutionIntToDouble() {
        byte[] originalIntData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(TestAvroDecoder.getAvroSchema("int_to_double_field", "\"int\"")), "int_to_double_field", 100);
        DecoderTestColumnHandle doubleColumnReadingIntData = new DecoderTestColumnHandle(0, "row0", (Type)DoubleType.DOUBLE, "int_to_double_field", null, null, false, false, false);
        String changedTypeSchema = TestAvroDecoder.getAvroSchema("int_to_double_field", "\"double\"");
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalIntData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)doubleColumnReadingIntData), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)changedTypeSchema));
        Assert.assertEquals((int)decodedEvolvedRow.size(), (int)1);
        DecoderTestUtil.checkValue(decodedEvolvedRow, (DecoderColumnHandle)doubleColumnReadingIntData, 100.0);
    }

    @Test
    public void testSchemaEvolutionToIncompatibleType() {
        byte[] originalIntData = TestAvroDecoder.buildAvroData(new Schema.Parser().parse(TestAvroDecoder.getAvroSchema("int_to_string_field", "\"int\"")), "int_to_string_field", 100);
        DecoderTestColumnHandle stringColumnReadingIntData = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "int_to_string_field", null, null, false, false, false);
        String changedTypeSchema = TestAvroDecoder.getAvroSchema("int_to_string_field", "\"string\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAvroDecoder.decodeRow(originalIntData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)stringColumnReadingIntData), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)changedTypeSchema))).isInstanceOf(PrestoException.class)).hasCauseExactlyInstanceOf(AvroTypeException.class).hasStackTraceContaining("Found int, expecting string").hasMessageMatching("Decoding Avro record failed.");
    }

    @Test
    public void testLongDecodedAsBigint() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)BigintType.BIGINT, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"long\"", 493857959588286460L);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 493857959588286460L);
    }

    @Test
    public void testIntDecodedAsBigint() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)BigintType.BIGINT, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"int\"", 100);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 100L);
    }

    @Test
    public void testFloatDecodedAsDouble() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)DoubleType.DOUBLE, "float_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "float_field", "\"float\"", Float.valueOf(10.2f));
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 10.2);
    }

    @Test
    public void testBytesDecodedAsVarbinary() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarbinaryType.VARBINARY, "encoded", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "encoded", "\"bytes\"", ByteBuffer.wrap("mytext".getBytes(StandardCharsets.UTF_8)));
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "mytext");
    }

    @Test
    public void testDoubleDecodedAsDouble() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)DoubleType.DOUBLE, "double_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "double_field", "\"double\"", 56.898);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 56.898);
    }

    @Test
    public void testStringDecodedAsVarcharN() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarcharType.createVarcharType((int)10), "varcharn_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "varcharn_field", "\"string\"", "abcdefghijklmno");
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "abcdefghij");
    }

    @Test
    public void testNestedRecord() {
        String schema = "{\"type\" : \"record\",   \"name\" : \"nested_schema\",  \"namespace\" : \"io.prestosql.decoder.avro\",  \"fields\" :  [{            \"name\":\"nested\",            \"type\":{                      \"type\":\"record\",                      \"name\":\"Nested\",                      \"fields\":                      [                          {                              \"name\":\"id\",                              \"type\":[\"long\", \"null\"]                          }                      ]                  }  }]}";
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)BigintType.BIGINT, "nested/id", null, null, false, false, false);
        Schema nestedSchema = new Schema.Parser().parse(schema);
        Schema userSchema = nestedSchema.getField("nested").schema();
        GenericData.Record userRecord = TestAvroDecoder.buildAvroRecord(userSchema, new ByteArrayOutputStream(), (Map<String, Object>)ImmutableMap.of((Object)"id", (Object)98247748L));
        byte[] avroData = TestAvroDecoder.buildAvroData(nestedSchema, "nested", userRecord);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = TestAvroDecoder.decodeRow(avroData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)row), (Map<String, String>)ImmutableMap.of((Object)DATA_SCHEMA, (Object)schema));
        Assert.assertEquals((int)decodedRow.size(), (int)1);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 98247748L);
    }

    @Test
    public void testNonExistentFieldsAreNull() {
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)VarcharType.createVarcharType((int)100), "very/deep/varchar", null, null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)BigintType.BIGINT, "no_bigint", null, null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)DoubleType.DOUBLE, "double_record/is_missing", null, null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)BooleanType.BOOLEAN, "hello", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow1 = this.buildAndDecodeColumn(row1, "dummy", "\"long\"", 0L);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow2 = this.buildAndDecodeColumn(row2, "dummy", "\"long\"", 0L);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow3 = this.buildAndDecodeColumn(row3, "dummy", "\"long\"", 0L);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow4 = this.buildAndDecodeColumn(row4, "dummy", "\"long\"", 0L);
        DecoderTestUtil.checkIsNull(decodedRow1, row1);
        DecoderTestUtil.checkIsNull(decodedRow2, row2);
        DecoderTestUtil.checkIsNull(decodedRow3, row3);
        DecoderTestUtil.checkIsNull(decodedRow4, row4);
    }

    @Test
    public void testRuntimeDecodingFailure() {
        DecoderTestColumnHandle booleanColumn = new DecoderTestColumnHandle(0, "some_column", (Type)BooleanType.BOOLEAN, "long_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(booleanColumn, "long_field", "\"long\"", 1L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FieldValueProvider)decodedRow.get(booleanColumn)).getBoolean()).isInstanceOf(PrestoException.class)).hasMessageMatching("cannot decode object of 'class java.lang.Long' as 'boolean' for column 'some_column'");
    }

    @Test
    public void testArrayDecodedAsArray() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)BigintType.BIGINT), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", "{\"type\": \"array\", \"items\": [\"long\"]}", ImmutableList.of((Object)114L, (Object)136L));
        TestAvroDecoder.checkArrayValue(decodedRow, row, new long[]{114L, 136L});
    }

    @Test
    public void testArrayWithNulls() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)BigintType.BIGINT), "array_field", null, null, false, false, false);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", "{\"type\": \"array\", \"items\": [\"null\"]}", values);
        TestAvroDecoder.checkArrayItemIsNull(decodedRow, row, new long[]{0L});
    }

    @Test
    public void testMapDecodedAsMap() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", VARCHAR_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", "{\"type\": \"map\", \"values\": \"string\"}", ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"def", (Object)"key3", (Object)"zyx"));
        TestAvroDecoder.checkMapValue(decodedRow, row, (Map<String, String>)ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"def", (Object)"key3", (Object)"zyx"));
    }

    @Test
    public void testMapWithNull() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", VARCHAR_MAP_TYPE, "map_field", null, null, false, false, false);
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("key1", null);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", "{\"type\": \"map\", \"values\": \"null\"}", expectedValues);
        TestAvroDecoder.checkMapValue(decodedRow, row, expectedValues);
    }

    private static void checkArrayValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, long[] expected) {
        Block actualBlock = TestAvroDecoder.getBlock(decodedRow, handle);
        Assert.assertEquals((int)actualBlock.getPositionCount(), (int)expected.length);
        for (int i = 0; i < actualBlock.getPositionCount(); ++i) {
            Assert.assertFalse((boolean)actualBlock.isNull(i));
            Assert.assertEquals((long)BigintType.BIGINT.getLong(actualBlock, i), (long)expected[i]);
        }
    }

    private static void checkArrayItemIsNull(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, long[] expected) {
        Block actualBlock = TestAvroDecoder.getBlock(decodedRow, handle);
        Assert.assertEquals((int)actualBlock.getPositionCount(), (int)expected.length);
        for (int i = 0; i < actualBlock.getPositionCount(); ++i) {
            Assert.assertTrue((boolean)actualBlock.isNull(i));
            Assert.assertEquals((long)BigintType.BIGINT.getLong(actualBlock, i), (long)expected[i]);
        }
    }

    private static void checkMapValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderTestColumnHandle handle, Map<String, String> expected) {
        Block actualBlock = TestAvroDecoder.getBlock(decodedRow, handle);
        Assert.assertEquals((int)actualBlock.getPositionCount(), (int)(expected.size() * 2));
        for (int i = 0; i < actualBlock.getPositionCount(); i += 2) {
            String actualKey = VarcharType.VARCHAR.getSlice(actualBlock, i).toStringUtf8();
            String actualValue = actualBlock.isNull(i + 1) ? null : VarcharType.VARCHAR.getSlice(actualBlock, i + 1).toStringUtf8();
            Assert.assertTrue((boolean)expected.containsKey(actualKey));
            Assert.assertEquals((String)actualValue, (String)expected.get(actualKey));
        }
    }

    private static Block getBlock(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assert.assertNotNull((Object)provider);
        return provider.getBlock();
    }

    @Test
    public void testInvalidExtraneousParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "mapping", null, "hint", false, false, false)).isInstanceOf(PrestoException.class)).hasMessageMatching("unexpected format hint 'hint' defined for column 'some_column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "mapping", null, null, false, false, true)).isInstanceOf(PrestoException.class)).hasMessageMatching("unexpected internal column 'some_column'");
    }

    @Test
    public void testSupportedDataTypeValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT);
        this.singleColumnDecoder((Type)VarbinaryType.VARBINARY);
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN);
        this.singleColumnDecoder((Type)DoubleType.DOUBLE);
        this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType());
        this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100));
        this.singleColumnDecoder((Type)new ArrayType((Type)BigintType.BIGINT));
        this.singleColumnDecoder(VARCHAR_MAP_TYPE);
        this.singleColumnDecoder(DOUBLE_MAP_TYPE);
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)RealType.REAL));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)IntegerType.INTEGER));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)SmallintType.SMALLINT));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DecimalType.createDecimalType((int)10, (int)4)));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)new ArrayType((Type)RealType.REAL)));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder(REAL_MAP_TYPE));
    }

    private void assertUnsupportedColumnTypeException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(PrestoException.class)).hasMessageMatching("Unsupported column type .* for column .*");
    }

    private void singleColumnDecoder(Type columnType) {
        String someSchema = TestAvroDecoder.getAvroSchema("dummy", "\"long\"");
        DECODER_FACTORY.create((Map)ImmutableMap.of((Object)DATA_SCHEMA, (Object)someSchema), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "some_column", columnType, "0", null, null, false, false, false)));
    }

    private void singleColumnDecoder(Type columnType, String mapping, String dataFormat, String formatHint, boolean keyDecoder, boolean hidden, boolean internal) {
        String someSchema = TestAvroDecoder.getAvroSchema("dummy", "\"long\"");
        DECODER_FACTORY.create((Map)ImmutableMap.of((Object)DATA_SCHEMA, (Object)someSchema), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "some_column", columnType, mapping, dataFormat, formatHint, keyDecoder, hidden, internal)));
    }
}

